/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.utils;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Logging {
    private final Logger log;
    static final String SF_LOG_TAG = "[SF_INGEST]";

    public Logging(Class name) {
        this.log = LoggerFactory.getLogger((Class)name);
    }

    public void logInfo(String msg) {
        if (this.log.isInfoEnabled()) {
            this.log.info(Logging.logMessage(msg));
        }
    }

    public void logTrace(String msg) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(Logging.logMessage(msg));
        }
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public void logDebug(String msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(Logging.logMessage(msg));
        }
    }

    public void logWarn(String msg) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(Logging.logMessage(msg));
        }
    }

    public void logError(String msg) {
        if (this.log.isErrorEnabled()) {
            this.log.error(Logging.logMessage(msg));
        }
    }

    public void logInfo(String format, Object ... vars) {
        if (this.log.isInfoEnabled()) {
            this.log.info(Logging.logMessage(format, vars));
        }
    }

    public void logTrace(String format, Object ... vars) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(Logging.logMessage(format, vars));
        }
    }

    public void logDebug(String format, Object ... vars) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(Logging.logMessage(format, vars));
        }
    }

    public void logWarn(String format, Throwable e) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(format, e);
        }
    }

    public void logWarn(String format, Object ... vars) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(format, vars);
        }
    }

    public void logError(String format, Object ... vars) {
        if (this.log.isErrorEnabled()) {
            this.log.error(Logging.logMessage(format, vars));
        }
    }

    public Logger getLogger() {
        return this.log;
    }

    private static String logMessage(String msg) {
        return "[SF_INGEST] " + msg;
    }

    private static String logMessage(String format, Object ... vars) {
        for (int i = 0; i < vars.length; ++i) {
            format = format.replaceFirst("\\{}", Objects.toString(vars[i]).replaceAll("\\$", "\\\\\\$"));
        }
        return Logging.logMessage(format);
    }
}

