/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.SFException;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.hadoop.BdecParquetWriter;
import org.apache.parquet.hadoop.InternalParquetRecordReader;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;

public class BdecParquetReader
implements AutoCloseable {
    private final InternalParquetRecordReader<List<Object>> reader;

    public BdecParquetReader(byte[] data) throws IOException {
        ParquetReadOptions options = ParquetReadOptions.builder().build();
        ParquetFileReader fileReader = ParquetFileReader.open((InputFile)new BdecInputFile(data), (ParquetReadOptions)options);
        this.reader = new InternalParquetRecordReader((ReadSupport)new BdecReadSupport(), options.getRecordFilter());
        this.reader.initialize(fileReader, options);
    }

    public List<Object> read() throws IOException {
        try {
            return this.reader.nextKeyValue() ? (List)this.reader.getCurrentValue() : null;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public static void readFileIntoWriter(byte[] data, BdecParquetWriter outputWriter) {
        try (BdecParquetReader reader = new BdecParquetReader(data);){
            List<Object> record = reader.read();
            while (record != null) {
                outputWriter.writeRow(record);
                record = reader.read();
            }
        }
        catch (IOException e) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "Failed to merge parquet files", e);
        }
    }

    private static class BdecRecordConverter
    extends GroupConverter {
        private final Converter[] converters;
        private final int fieldNumber;
        private Object[] record;

        public BdecRecordConverter(GroupType schema) {
            this.converters = new Converter[schema.getFieldCount()];
            this.fieldNumber = schema.getFields().size();
            for (int i = 0; i < this.fieldNumber; ++i) {
                this.converters[i] = new BdecPrimitiveConverter(i);
            }
        }

        public Converter getConverter(int fieldIndex) {
            return this.converters[fieldIndex];
        }

        List<Object> getCurrentRecord() {
            return Arrays.asList(this.record);
        }

        public void start() {
            this.record = new Object[this.fieldNumber];
        }

        public void end() {
        }

        private class BdecPrimitiveConverter
        extends PrimitiveConverter {
            protected final int index;

            public BdecPrimitiveConverter(int index) {
                this.index = index;
            }

            public void addBinary(Binary value) {
                ((BdecRecordConverter)BdecRecordConverter.this).record[this.index] = value.getBytes();
            }

            public void addBoolean(boolean value) {
                ((BdecRecordConverter)BdecRecordConverter.this).record[this.index] = value;
            }

            public void addDouble(double value) {
                ((BdecRecordConverter)BdecRecordConverter.this).record[this.index] = value;
            }

            public void addFloat(float value) {
                ((BdecRecordConverter)BdecRecordConverter.this).record[this.index] = Float.valueOf(value);
            }

            public void addInt(int value) {
                ((BdecRecordConverter)BdecRecordConverter.this).record[this.index] = value;
            }

            public void addLong(long value) {
                ((BdecRecordConverter)BdecRecordConverter.this).record[this.index] = value;
            }
        }
    }

    private static class BdecRecordMaterializer
    extends RecordMaterializer<List<Object>> {
        public final BdecRecordConverter root;

        public BdecRecordMaterializer(MessageType schema) {
            this.root = new BdecRecordConverter((GroupType)schema);
        }

        public List<Object> getCurrentRecord() {
            return this.root.getCurrentRecord();
        }

        public GroupConverter getRootConverter() {
            return this.root;
        }
    }

    private static class BdecReadSupport
    extends ReadSupport<List<Object>> {
        private BdecReadSupport() {
        }

        public RecordMaterializer<List<Object>> prepareForRead(Configuration conf, Map<String, String> metaData, MessageType schema, ReadSupport.ReadContext context) {
            return new BdecRecordMaterializer(schema);
        }

        public ReadSupport.ReadContext init(InitContext context) {
            return new ReadSupport.ReadContext(context.getFileSchema());
        }
    }

    private static class BdecByteArrayInputStream
    extends ByteArrayInputStream {
        public BdecByteArrayInputStream(byte[] buf) {
            super(buf);
        }

        long getPos() {
            return this.pos;
        }

        void seek(long newPos) {
            this.pos = (int)newPos;
        }
    }

    private static class BdecSeekableInputStream
    extends DelegatingSeekableInputStream {
        private final BdecByteArrayInputStream stream;

        public BdecSeekableInputStream(BdecByteArrayInputStream stream) {
            super((InputStream)stream);
            this.stream = stream;
        }

        public long getPos() {
            return this.stream.getPos();
        }

        public void seek(long newPos) {
            this.stream.seek(newPos);
        }
    }

    private static class BdecInputFile
    implements InputFile {
        private final byte[] data;

        private BdecInputFile(byte[] data) {
            this.data = data;
        }

        public long getLength() {
            return this.data.length;
        }

        public SeekableInputStream newStream() {
            return new BdecSeekableInputStream(new BdecByteArrayInputStream(this.data));
        }
    }
}

