/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.commons.configuration2;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import net.snowflake.ingest.internal.apache.commons.configuration2.AbstractYAMLBasedConfiguration;
import net.snowflake.ingest.internal.apache.commons.configuration2.FileBasedConfiguration;
import net.snowflake.ingest.internal.apache.commons.configuration2.HierarchicalConfiguration;
import net.snowflake.ingest.internal.apache.commons.configuration2.ex.ConfigurationException;
import net.snowflake.ingest.internal.apache.commons.configuration2.io.InputStreamSupport;
import net.snowflake.ingest.internal.apache.commons.configuration2.tree.ImmutableNode;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.JavaType;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.type.MapType;

public class JSONConfiguration
extends AbstractYAMLBasedConfiguration
implements FileBasedConfiguration,
InputStreamSupport {
    private final ObjectMapper mapper = new ObjectMapper();
    private final MapType type = this.mapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class);

    public JSONConfiguration() {
    }

    public JSONConfiguration(HierarchicalConfiguration<ImmutableNode> c) {
        super(c);
    }

    @Override
    public void read(Reader in) throws ConfigurationException {
        try {
            this.load((Map)this.mapper.readValue(in, (JavaType)this.type));
        }
        catch (Exception e) {
            JSONConfiguration.rethrowException(e);
        }
    }

    @Override
    public void write(Writer out) throws ConfigurationException, IOException {
        this.mapper.writer().writeValue(out, this.constructMap(this.getNodeModel().getNodeHandler().getRootNode()));
    }

    @Override
    public void read(InputStream in) throws ConfigurationException {
        try {
            this.load((Map)this.mapper.readValue(in, (JavaType)this.type));
        }
        catch (Exception e) {
            JSONConfiguration.rethrowException(e);
        }
    }
}

