/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.audit;

import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class CommonAuditContext {
    private static final Logger LOG = LoggerFactory.getLogger(CommonAuditContext.class);
    public static final String PROCESS_ID = UUID.randomUUID().toString();
    private static final Map<String, String> GLOBAL_CONTEXT_MAP = new ConcurrentHashMap<String, String>();
    private final Map<String, Supplier<String>> evaluatedEntries = new ConcurrentHashMap<String, Supplier<String>>(1);
    private static final ThreadLocal<CommonAuditContext> ACTIVE_CONTEXT;

    private CommonAuditContext() {
    }

    public Supplier<String> put(String key, String value) {
        if (value != null) {
            return this.evaluatedEntries.put(key, () -> value);
        }
        return this.evaluatedEntries.remove(key);
    }

    public Supplier<String> put(String key, Supplier<String> value) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Adding context entry {}", (Object)key, (Object)new Exception(key));
        }
        return this.evaluatedEntries.put(key, value);
    }

    public void remove(String key) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Remove context entry {}", (Object)key);
        }
        this.evaluatedEntries.remove(key);
    }

    public String get(String key) {
        Supplier<String> supplier = this.evaluatedEntries.get(key);
        return supplier != null ? supplier.get() : null;
    }

    public void reset() {
        this.evaluatedEntries.clear();
        this.init();
    }

    private void init() {
        this.put("t1", CommonAuditContext::currentThreadID);
    }

    public boolean containsKey(String key) {
        return this.evaluatedEntries.containsKey(key);
    }

    private static CommonAuditContext createInstance() {
        CommonAuditContext context = new CommonAuditContext();
        context.init();
        return context;
    }

    public static CommonAuditContext currentAuditContext() {
        return ACTIVE_CONTEXT.get();
    }

    public static String currentThreadID() {
        return Long.toString(Thread.currentThread().getId());
    }

    public Map<String, Supplier<String>> getEvaluatedEntries() {
        return this.evaluatedEntries;
    }

    public static void setGlobalContextEntry(String key, String value) {
        GLOBAL_CONTEXT_MAP.put(key, value);
    }

    public static String getGlobalContextEntry(String key) {
        return GLOBAL_CONTEXT_MAP.get(key);
    }

    public static void removeGlobalContextEntry(String key) {
        GLOBAL_CONTEXT_MAP.remove(key);
    }

    public static void noteEntryPoint(Object tool) {
        if (tool != null && !GLOBAL_CONTEXT_MAP.containsKey("cm")) {
            String classname = tool.getClass().toString();
            int lastDot = classname.lastIndexOf(46);
            int l = classname.length();
            if (lastDot > 0 && lastDot < l - 1) {
                String name = classname.substring(lastDot + 1, l);
                CommonAuditContext.setGlobalContextEntry("cm", name);
            }
        }
    }

    public static Iterable<Map.Entry<String, String>> getGlobalContextEntries() {
        return new GlobalIterable();
    }

    static {
        CommonAuditContext.setGlobalContextEntry("ps", PROCESS_ID);
        ACTIVE_CONTEXT = ThreadLocal.withInitial(CommonAuditContext::createInstance);
    }

    private static final class GlobalIterable
    implements Iterable<Map.Entry<String, String>> {
        private GlobalIterable() {
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return GLOBAL_CONTEXT_MAP.entrySet().iterator();
        }
    }
}

