/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.ha;

import java.io.IOException;
import java.net.InetSocketAddress;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.ha.ZKFCProtocol;
import net.snowflake.ingest.internal.apache.hadoop.ha.ZKFailoverController;
import net.snowflake.ingest.internal.apache.hadoop.ha.proto.ZKFCProtocolProtos;
import net.snowflake.ingest.internal.apache.hadoop.ha.protocolPB.ZKFCProtocolPB;
import net.snowflake.ingest.internal.apache.hadoop.ha.protocolPB.ZKFCProtocolServerSideTranslatorPB;
import net.snowflake.ingest.internal.apache.hadoop.ipc.ProtobufRpcEngine2;
import net.snowflake.ingest.internal.apache.hadoop.ipc.RPC;
import net.snowflake.ingest.internal.apache.hadoop.security.AccessControlException;
import net.snowflake.ingest.internal.apache.hadoop.security.authorize.PolicyProvider;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.protobuf.BlockingService;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
@InterfaceStability.Evolving
public class ZKFCRpcServer
implements ZKFCProtocol {
    private static final int HANDLER_COUNT = 3;
    private final ZKFailoverController zkfc;
    private RPC.Server server;

    ZKFCRpcServer(Configuration conf, InetSocketAddress bindAddr, ZKFailoverController zkfc, PolicyProvider policy) throws IOException {
        this.zkfc = zkfc;
        RPC.setProtocolEngine(conf, ZKFCProtocolPB.class, ProtobufRpcEngine2.class);
        ZKFCProtocolServerSideTranslatorPB translator = new ZKFCProtocolServerSideTranslatorPB(this);
        BlockingService service = ZKFCProtocolProtos.ZKFCProtocolService.newReflectiveBlockingService(translator);
        this.server = new RPC.Builder(conf).setProtocol(ZKFCProtocolPB.class).setInstance(service).setBindAddress(bindAddr.getHostName()).setPort(bindAddr.getPort()).setNumHandlers(3).setVerbose(false).build();
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.server.refreshServiceAcl(conf, policy);
        }
    }

    void start() {
        this.server.start();
    }

    public InetSocketAddress getAddress() {
        return this.server.getListenerAddress();
    }

    void stopAndJoin() throws InterruptedException {
        this.server.stop();
        this.server.join();
    }

    @Override
    public void cedeActive(int millisToCede) throws IOException, AccessControlException {
        this.zkfc.checkRpcAdminAccess();
        this.zkfc.cedeActive(millisToCede);
    }

    @Override
    public void gracefulFailover() throws IOException, AccessControlException {
        this.zkfc.checkRpcAdminAccess();
        this.zkfc.gracefulFailoverToYou();
    }
}

