/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.ha.protocolPB;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.SocketFactory;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.ha.ZKFCProtocol;
import net.snowflake.ingest.internal.apache.hadoop.ha.proto.ZKFCProtocolProtos;
import net.snowflake.ingest.internal.apache.hadoop.ha.protocolPB.ZKFCProtocolPB;
import net.snowflake.ingest.internal.apache.hadoop.ipc.ProtobufHelper;
import net.snowflake.ingest.internal.apache.hadoop.ipc.ProtobufRpcEngine2;
import net.snowflake.ingest.internal.apache.hadoop.ipc.ProtocolTranslator;
import net.snowflake.ingest.internal.apache.hadoop.ipc.RPC;
import net.snowflake.ingest.internal.apache.hadoop.security.AccessControlException;
import net.snowflake.ingest.internal.apache.hadoop.security.UserGroupInformation;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.protobuf.RpcController;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.protobuf.ServiceException;

public class ZKFCProtocolClientSideTranslatorPB
implements ZKFCProtocol,
Closeable,
ProtocolTranslator {
    private static final RpcController NULL_CONTROLLER = null;
    private final ZKFCProtocolPB rpcProxy;

    public ZKFCProtocolClientSideTranslatorPB(InetSocketAddress addr, Configuration conf, SocketFactory socketFactory, int timeout) throws IOException {
        RPC.setProtocolEngine(conf, ZKFCProtocolPB.class, ProtobufRpcEngine2.class);
        this.rpcProxy = RPC.getProxy(ZKFCProtocolPB.class, RPC.getProtocolVersion(ZKFCProtocolPB.class), addr, UserGroupInformation.getCurrentUser(), conf, socketFactory, timeout);
    }

    @Override
    public void cedeActive(int millisToCede) throws IOException, AccessControlException {
        try {
            ZKFCProtocolProtos.CedeActiveRequestProto req = ZKFCProtocolProtos.CedeActiveRequestProto.newBuilder().setMillisToCede(millisToCede).build();
            this.rpcProxy.cedeActive(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void gracefulFailover() throws IOException, AccessControlException {
        try {
            this.rpcProxy.gracefulFailover(NULL_CONTROLLER, ZKFCProtocolProtos.GracefulFailoverRequestProto.getDefaultInstance());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void close() {
        RPC.stopProxy(this.rpcProxy);
    }

    @Override
    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }
}

