/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class MultipleIOException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final List<IOException> exceptions;

    private MultipleIOException(List<IOException> exceptions) {
        super(exceptions.size() + " exceptions " + exceptions);
        this.exceptions = exceptions;
    }

    public List<IOException> getExceptions() {
        return this.exceptions;
    }

    public static IOException createIOException(List<IOException> exceptions) {
        if (exceptions == null || exceptions.isEmpty()) {
            return null;
        }
        if (exceptions.size() == 1) {
            return exceptions.get(0);
        }
        return new MultipleIOException(exceptions);
    }

    public static class Builder {
        private List<IOException> exceptions;

        public void add(Throwable t2) {
            if (this.exceptions == null) {
                this.exceptions = new ArrayList<IOException>();
            }
            this.exceptions.add(t2 instanceof IOException ? (IOException)t2 : new IOException(t2));
        }

        public IOException build() {
            return MultipleIOException.createIOException(this.exceptions);
        }

        public boolean isEmpty() {
            if (this.exceptions == null) {
                return true;
            }
            return this.exceptions.isEmpty();
        }
    }
}

