/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.coder;

import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configured;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.ECBlock;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.ECBlockGroup;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.coder.ErasureCoder;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;

@InterfaceAudience.Private
public abstract class ErasureEncoder
extends Configured
implements ErasureCoder {
    private final int numDataUnits;
    private final int numParityUnits;
    private final ErasureCoderOptions options;

    public ErasureEncoder(ErasureCoderOptions options) {
        this.options = options;
        this.numDataUnits = options.getNumDataUnits();
        this.numParityUnits = options.getNumParityUnits();
    }

    @Override
    public ErasureCodingStep calculateCoding(ECBlockGroup blockGroup) {
        return this.prepareEncodingStep(blockGroup);
    }

    @Override
    public int getNumDataUnits() {
        return this.numDataUnits;
    }

    @Override
    public int getNumParityUnits() {
        return this.numParityUnits;
    }

    @Override
    public ErasureCoderOptions getOptions() {
        return this.options;
    }

    protected ECBlock[] getInputBlocks(ECBlockGroup blockGroup) {
        return blockGroup.getDataBlocks();
    }

    protected ECBlock[] getOutputBlocks(ECBlockGroup blockGroup) {
        return blockGroup.getParityBlocks();
    }

    @Override
    public boolean preferDirectBuffer() {
        return false;
    }

    @Override
    public void release() {
    }

    protected abstract ErasureCodingStep prepareEncodingStep(ECBlockGroup var1);
}

