/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.rawcoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.ErasureCodeNative;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.rawcoder.AbstractNativeRawDecoder;

@InterfaceAudience.Private
public class NativeXORRawDecoder
extends AbstractNativeRawDecoder {
    public NativeXORRawDecoder(ErasureCoderOptions coderOptions) {
        super(coderOptions);
        this.decoderLock.writeLock().lock();
        try {
            this.initImpl(coderOptions.getNumDataUnits(), coderOptions.getNumParityUnits());
        }
        finally {
            this.decoderLock.writeLock().unlock();
        }
    }

    @Override
    protected void performDecodeImpl(ByteBuffer[] inputs, int[] inputOffsets, int dataLen, int[] erased, ByteBuffer[] outputs, int[] outputOffsets) throws IOException {
        this.decodeImpl(inputs, inputOffsets, dataLen, erased, outputs, outputOffsets);
    }

    @Override
    public void release() {
        this.decoderLock.writeLock().lock();
        try {
            this.destroyImpl();
        }
        finally {
            this.decoderLock.writeLock().unlock();
        }
    }

    private native void initImpl(int var1, int var2);

    private native void decodeImpl(ByteBuffer[] var1, int[] var2, int var3, int[] var4, ByteBuffer[] var5, int[] var6) throws IOException;

    private native void destroyImpl();

    static {
        ErasureCodeNative.checkNativeCodeLoaded();
    }
}

