/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io.serializer.avro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.snowflake.ingest.internal.apache.avro.Schema;
import net.snowflake.ingest.internal.apache.avro.io.BinaryDecoder;
import net.snowflake.ingest.internal.apache.avro.io.BinaryEncoder;
import net.snowflake.ingest.internal.apache.avro.io.DatumReader;
import net.snowflake.ingest.internal.apache.avro.io.DatumWriter;
import net.snowflake.ingest.internal.apache.avro.io.Decoder;
import net.snowflake.ingest.internal.apache.avro.io.DecoderFactory;
import net.snowflake.ingest.internal.apache.avro.io.Encoder;
import net.snowflake.ingest.internal.apache.avro.io.EncoderFactory;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configured;
import net.snowflake.ingest.internal.apache.hadoop.io.serializer.Deserializer;
import net.snowflake.ingest.internal.apache.hadoop.io.serializer.Serialization;
import net.snowflake.ingest.internal.apache.hadoop.io.serializer.Serializer;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class AvroSerialization<T>
extends Configured
implements Serialization<T> {
    @InterfaceAudience.Private
    public static final String AVRO_SCHEMA_KEY = "Avro-Schema";

    @Override
    @InterfaceAudience.Private
    public Deserializer<T> getDeserializer(Class<T> c) {
        return new AvroDeserializer(c);
    }

    @Override
    @InterfaceAudience.Private
    public Serializer<T> getSerializer(Class<T> c) {
        return new AvroSerializer(c);
    }

    @InterfaceAudience.Private
    public abstract Schema getSchema(T var1);

    @InterfaceAudience.Private
    public abstract DatumWriter<T> getWriter(Class<T> var1);

    @InterfaceAudience.Private
    public abstract DatumReader<T> getReader(Class<T> var1);

    class AvroDeserializer
    implements Deserializer<T> {
        private DatumReader<T> reader;
        private BinaryDecoder decoder;
        private InputStream inStream;

        AvroDeserializer(Class<T> clazz) {
            this.reader = AvroSerialization.this.getReader(clazz);
        }

        @Override
        public void close() throws IOException {
            this.inStream.close();
        }

        @Override
        public T deserialize(T t2) throws IOException {
            return this.reader.read(t2, (Decoder)this.decoder);
        }

        @Override
        public void open(InputStream in) throws IOException {
            this.inStream = in;
            this.decoder = DecoderFactory.get().binaryDecoder(in, this.decoder);
        }
    }

    class AvroSerializer
    implements Serializer<T> {
        private DatumWriter<T> writer;
        private BinaryEncoder encoder;
        private OutputStream outStream;

        AvroSerializer(Class<T> clazz) {
            this.writer = AvroSerialization.this.getWriter(clazz);
        }

        @Override
        public void close() throws IOException {
            this.encoder.flush();
            this.outStream.close();
        }

        @Override
        public void open(OutputStream out) throws IOException {
            this.outStream = out;
            this.encoder = EncoderFactory.get().binaryEncoder(out, this.encoder);
        }

        @Override
        public void serialize(T t2) throws IOException {
            this.writer.setSchema(AvroSerialization.this.getSchema(t2));
            this.writer.write(t2, (Encoder)this.encoder);
        }
    }
}

