/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.snowflake.ingest.internal.apache.hadoop.net.InnerNode;
import net.snowflake.ingest.internal.apache.hadoop.net.Node;
import net.snowflake.ingest.internal.apache.hadoop.net.NodeBase;

public class InnerNodeImpl
extends NodeBase
implements InnerNode {
    static final Factory FACTORY = new Factory();
    protected final List<Node> children = new ArrayList<Node>();
    protected final Map<String, Node> childrenMap = new HashMap<String, Node>();
    protected int numOfLeaves;

    protected InnerNodeImpl(String path) {
        super(path);
    }

    protected InnerNodeImpl(String name, String location, InnerNode parent, int level) {
        super(name, location, parent, level);
    }

    @Override
    public List<Node> getChildren() {
        return this.children;
    }

    @Override
    public int getNumOfChildren() {
        return this.children.size();
    }

    public boolean isRack() {
        if (this.children.isEmpty()) {
            return true;
        }
        Node firstChild = this.children.get(0);
        return !(firstChild instanceof InnerNode);
    }

    public boolean isAncestor(Node n) {
        return InnerNodeImpl.getPath(this).equals("/") || (n.getNetworkLocation() + "/").startsWith(InnerNodeImpl.getPath(this) + "/");
    }

    public boolean isParent(Node n) {
        return n.getNetworkLocation().equals(InnerNodeImpl.getPath(this));
    }

    public String getNextAncestorName(Node n) {
        int index;
        if (!this.isAncestor(n)) {
            throw new IllegalArgumentException(this + "is not an ancestor of " + n);
        }
        String name = n.getNetworkLocation().substring(InnerNodeImpl.getPath(this).length());
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        if ((index = name.indexOf(47)) != -1) {
            name = name.substring(0, index);
        }
        return name;
    }

    @Override
    public boolean add(Node n) {
        if (!this.isAncestor(n)) {
            throw new IllegalArgumentException(n.getName() + ", which is located at " + n.getNetworkLocation() + ", is not a descendant of " + InnerNodeImpl.getPath(this));
        }
        if (this.isParent(n)) {
            n.setParent(this);
            n.setLevel(this.level + 1);
            Node prev = this.childrenMap.put(n.getName(), n);
            if (prev != null) {
                for (int i = 0; i < this.children.size(); ++i) {
                    if (!this.children.get(i).getName().equals(n.getName())) continue;
                    this.children.set(i, n);
                    return false;
                }
            }
            this.children.add(n);
            ++this.numOfLeaves;
            return true;
        }
        String parentName = this.getNextAncestorName(n);
        InnerNode parentNode = (InnerNode)this.childrenMap.get(parentName);
        if (parentNode == null) {
            parentNode = this.createParentNode(parentName);
            this.children.add(parentNode);
            this.childrenMap.put(parentNode.getName(), parentNode);
        }
        if (parentNode.add(n)) {
            ++this.numOfLeaves;
            return true;
        }
        return false;
    }

    private InnerNodeImpl createParentNode(String parentName) {
        return new InnerNodeImpl(parentName, InnerNodeImpl.getPath(this), this, this.getLevel() + 1);
    }

    @Override
    public boolean remove(Node n) {
        if (!this.isAncestor(n)) {
            throw new IllegalArgumentException(n.getName() + ", which is located at " + n.getNetworkLocation() + ", is not a descendant of " + InnerNodeImpl.getPath(this));
        }
        if (this.isParent(n)) {
            if (this.childrenMap.containsKey(n.getName())) {
                for (int i = 0; i < this.children.size(); ++i) {
                    if (!this.children.get(i).getName().equals(n.getName())) continue;
                    this.children.remove(i);
                    this.childrenMap.remove(n.getName());
                    --this.numOfLeaves;
                    n.setParent(null);
                    return true;
                }
            }
            return false;
        }
        String parentName = this.getNextAncestorName(n);
        InnerNodeImpl parentNode = (InnerNodeImpl)this.childrenMap.get(parentName);
        if (parentNode == null) {
            return false;
        }
        boolean isRemoved = parentNode.remove(n);
        if (isRemoved) {
            if (parentNode.getNumOfChildren() == 0) {
                for (int i = 0; i < this.children.size(); ++i) {
                    if (!this.children.get(i).getName().equals(parentName)) continue;
                    this.children.remove(i);
                    this.childrenMap.remove(parentName);
                    break;
                }
            }
            --this.numOfLeaves;
        }
        return isRemoved;
    }

    @Override
    public Node getLoc(String loc) {
        if (loc == null || loc.length() == 0) {
            return this;
        }
        String[] path = loc.split("/", 2);
        Node childNode = this.childrenMap.get(path[0]);
        if (childNode == null || path.length == 1) {
            return childNode;
        }
        if (childNode instanceof InnerNode) {
            return ((InnerNode)childNode).getLoc(path[1]);
        }
        return null;
    }

    @Override
    public Node getLeaf(int leafIndex, Node excludedNode) {
        int numOfExcludedLeaves;
        int count = 0;
        boolean isLeaf = !(excludedNode instanceof InnerNode);
        int n = numOfExcludedLeaves = isLeaf ? 1 : ((InnerNode)excludedNode).getNumOfLeaves();
        if (this.isLeafParent()) {
            int excludedIndex;
            if (isLeaf && excludedNode != null && this.childrenMap.containsKey(excludedNode.getName()) && (excludedIndex = this.children.indexOf(excludedNode)) != -1 && leafIndex >= 0) {
                int n2 = leafIndex = leafIndex >= excludedIndex ? leafIndex + 1 : leafIndex;
            }
            if (leafIndex < 0 || leafIndex >= this.getNumOfChildren()) {
                return null;
            }
            return this.children.get(leafIndex);
        }
        for (int i = 0; i < this.children.size(); ++i) {
            InnerNodeImpl child = (InnerNodeImpl)this.children.get(i);
            if (excludedNode == null || excludedNode != child) {
                int numOfLeaves = child.getNumOfLeaves();
                if (excludedNode != null && child.isAncestor(excludedNode)) {
                    numOfLeaves -= numOfExcludedLeaves;
                }
                if (count + numOfLeaves > leafIndex) {
                    return child.getLeaf(leafIndex - count, excludedNode);
                }
                count += numOfLeaves;
                continue;
            }
            excludedNode = null;
        }
        return null;
    }

    private boolean isLeafParent() {
        return this.isRack();
    }

    @Override
    public int getNumOfLeaves() {
        return this.numOfLeaves;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object to) {
        return super.equals(to);
    }

    protected static class Factory
    implements InnerNode.Factory<InnerNodeImpl> {
        protected Factory() {
        }

        @Override
        public InnerNodeImpl newInnerNode(String path) {
            return new InnerNodeImpl(path);
        }
    }
}

