/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.net;

import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.net.InnerNode;
import net.snowflake.ingest.internal.apache.hadoop.net.InnerNodeImpl;
import net.snowflake.ingest.internal.apache.hadoop.net.NetworkTopology;
import net.snowflake.ingest.internal.apache.hadoop.net.Node;
import net.snowflake.ingest.internal.apache.hadoop.net.NodeBase;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class NetworkTopologyWithNodeGroup
extends NetworkTopology {
    public static final String DEFAULT_NODEGROUP = "/default-nodegroup";

    public NetworkTopologyWithNodeGroup() {
        this.clusterMap = new InnerNodeWithNodeGroup("");
    }

    @Override
    protected Node getNodeForNetworkLocation(Node node) {
        Node nodeGroup;
        if ("/default-rack".equals(node.getNetworkLocation())) {
            node.setNetworkLocation(node.getNetworkLocation() + DEFAULT_NODEGROUP);
        }
        if ((nodeGroup = this.getNode(node.getNetworkLocation())) == null) {
            nodeGroup = new InnerNodeWithNodeGroup(node.getNetworkLocation());
        }
        return this.getNode(nodeGroup.getNetworkLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRack(String loc) {
        this.netlock.readLock().lock();
        try {
            loc = NodeBase.normalize(loc);
            Node locNode = this.getNode(loc);
            if (locNode instanceof InnerNodeWithNodeGroup) {
                InnerNodeWithNodeGroup node = (InnerNodeWithNodeGroup)locNode;
                if (node.isRack()) {
                    String string = loc;
                    return string;
                }
                if (node.isNodeGroup()) {
                    String string = node.getNetworkLocation();
                    return string;
                }
                String string = null;
                return string;
            }
            String string = loc;
            return string;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNodeGroup(String loc) {
        this.netlock.readLock().lock();
        try {
            loc = NodeBase.normalize(loc);
            Node locNode = this.getNode(loc);
            if (locNode instanceof InnerNodeWithNodeGroup) {
                InnerNodeWithNodeGroup node = (InnerNodeWithNodeGroup)locNode;
                if (node.isNodeGroup()) {
                    String string = loc;
                    return string;
                }
                if (node.isRack()) {
                    String string = null;
                    return string;
                }
                if (node.getNetworkLocation() != null && !node.getNetworkLocation().isEmpty()) {
                    String string = this.getNodeGroup(node.getNetworkLocation());
                    return string;
                }
                String string = "";
                return string;
            }
            String string = loc;
            return string;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOnSameRack(Node node1, Node node2) {
        if (node1 == null || node2 == null || node1.getParent() == null || node2.getParent() == null) {
            return false;
        }
        this.netlock.readLock().lock();
        try {
            boolean bl = this.isSameParents(node1.getParent(), node2.getParent());
            return bl;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOnSameNodeGroup(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        this.netlock.readLock().lock();
        try {
            boolean bl = this.isSameParents(node1, node2);
            return bl;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    @Override
    public boolean isNodeGroupAware() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Node node) {
        if (node == null) {
            return;
        }
        if (node instanceof InnerNode) {
            throw new IllegalArgumentException("Not allow to add an inner node: " + NodeBase.getPath(node));
        }
        this.netlock.writeLock().lock();
        try {
            Node nodeGroup;
            Node rack = null;
            if ("/default-rack".equals(node.getNetworkLocation())) {
                node.setNetworkLocation(node.getNetworkLocation() + DEFAULT_NODEGROUP);
            }
            if ((nodeGroup = this.getNode(node.getNetworkLocation())) == null) {
                nodeGroup = new InnerNodeWithNodeGroup(node.getNetworkLocation());
            }
            if (!((rack = this.getNode(nodeGroup.getNetworkLocation())) == null || rack instanceof InnerNode && rack.getParent() != null)) {
                throw new IllegalArgumentException("Unexpected data node " + node.toString() + " at an illegal network location");
            }
            if (this.clusterMap.add(node)) {
                LOG.info("Adding a new node: " + NodeBase.getPath(node));
                if (rack == null) {
                    this.incrementRacks();
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("NetworkTopology became:\n" + this.toString());
            }
        }
        finally {
            this.netlock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Node node) {
        if (node == null) {
            return;
        }
        if (node instanceof InnerNode) {
            throw new IllegalArgumentException("Not allow to remove an inner node: " + NodeBase.getPath(node));
        }
        LOG.info("Removing a node: " + NodeBase.getPath(node));
        this.netlock.writeLock().lock();
        try {
            if (this.clusterMap.remove(node)) {
                InnerNode rack;
                Node nodeGroup = this.getNode(node.getNetworkLocation());
                if (nodeGroup == null) {
                    nodeGroup = this.factory.newInnerNode(node.getNetworkLocation());
                }
                if ((rack = (InnerNode)this.getNode(nodeGroup.getNetworkLocation())) == null) {
                    --this.numOfRacks;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("NetworkTopology became:\n" + this.toString());
            }
        }
        finally {
            this.netlock.writeLock().unlock();
        }
    }

    @Override
    protected int getWeight(Node reader, Node node) {
        int weight = 3;
        if (reader != null) {
            if (reader.equals(node)) {
                weight = 0;
            } else if (this.isOnSameNodeGroup(reader, node)) {
                weight = 1;
            } else if (this.isOnSameRack(reader, node)) {
                weight = 2;
            }
        }
        return weight;
    }

    @Override
    public void sortByDistance(Node reader, Node[] nodes, int activeLen) {
        if (reader != null && !this.contains(reader)) {
            Node nodeGroup = this.getNode(reader.getNetworkLocation());
            if (nodeGroup != null && nodeGroup instanceof InnerNode) {
                InnerNode parentNode = (InnerNode)nodeGroup;
                reader = parentNode.getLeaf(0, null);
            } else {
                return;
            }
        }
        super.sortByDistance(reader, nodes, activeLen);
    }

    static class InnerNodeWithNodeGroup
    extends InnerNodeImpl {
        public InnerNodeWithNodeGroup(String path) {
            super(path);
        }

        @Override
        public boolean isRack() {
            if (this.getChildren().isEmpty()) {
                return false;
            }
            Node firstChild = this.getChildren().get(0);
            if (firstChild instanceof InnerNode) {
                Node firstGrandChild = ((InnerNode)firstChild).getChildren().get(0);
                return !(firstGrandChild instanceof InnerNode);
            }
            return false;
        }

        boolean isNodeGroup() {
            if (this.getChildren().isEmpty()) {
                return true;
            }
            Node firstChild = this.getChildren().get(0);
            return !(firstChild instanceof InnerNode);
        }
    }
}

