/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.snowflake.ingest.internal.apache.commons.cli.CommandLine;
import net.snowflake.ingest.internal.apache.commons.cli.GnuParser;
import net.snowflake.ingest.internal.apache.commons.cli.MissingArgumentException;
import net.snowflake.ingest.internal.apache.commons.cli.Option;
import net.snowflake.ingest.internal.apache.commons.cli.OptionBuilder;
import net.snowflake.ingest.internal.apache.commons.cli.Options;
import net.snowflake.ingest.internal.apache.commons.cli.ParseException;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.util.GenericOptionsParser;
import net.snowflake.ingest.internal.apache.hadoop.util.NodeInfo;
import net.snowflake.ingest.internal.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public final class ConfTest {
    private static final String USAGE = "Usage: hadoop conftest [-conffile <path>|-h|--help]\n  Options:\n  \n  -conffile <path>\n    If not specified, the files in ${HADOOP_CONF_DIR}\n    whose name end with .xml will be verified.\n    If specified, that path will be verified.\n    You can specify either a file or directory, and\n    if a directory specified, the files in that directory\n    whose name end with .xml will be verified.\n    You can specify this option multiple times.\n  -h, --help       Print this help";
    private static final String HADOOP_CONF_DIR = "HADOOP_CONF_DIR";

    protected ConfTest() {
    }

    private static List<NodeInfo> parseConf(InputStream in) throws XMLStreamException {
        QName configuration = new QName("configuration");
        QName property = new QName("property");
        ArrayList<NodeInfo> nodes = new ArrayList<NodeInfo>();
        Stack<NodeInfo> parsed = new Stack<NodeInfo>();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader reader = factory.createXMLEventReader(in);
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement currentElement = event.asStartElement();
                NodeInfo currentNode = new NodeInfo(currentElement);
                if (parsed.isEmpty()) {
                    if (!currentElement.getName().equals(configuration)) {
                        return null;
                    }
                } else {
                    NodeInfo parentNode = (NodeInfo)parsed.peek();
                    QName parentName = parentNode.getStartElement().getName();
                    if (parentName.equals(configuration) && currentNode.getStartElement().getName().equals(property)) {
                        Iterator<Attribute> it = currentElement.getAttributes();
                        while (it.hasNext()) {
                            currentNode.addAttribute(it.next());
                        }
                    } else if (parentName.equals(property)) {
                        parentNode.addElement(currentElement);
                    }
                }
                parsed.push(currentNode);
                continue;
            }
            if (event.isEndElement()) {
                NodeInfo node = (NodeInfo)parsed.pop();
                if (parsed.size() != 1) continue;
                nodes.add(node);
                continue;
            }
            if (!event.isCharacters() || 2 >= parsed.size()) continue;
            NodeInfo parentNode = (NodeInfo)parsed.pop();
            StartElement parentElement = parentNode.getStartElement();
            NodeInfo grandparentNode = (NodeInfo)parsed.peek();
            if (grandparentNode.getElement(parentElement) == null) {
                grandparentNode.setElement(parentElement, event.asCharacters());
            }
            parsed.push(parentNode);
        }
        return nodes;
    }

    public static List<String> checkConf(InputStream in) {
        List<NodeInfo> nodes = null;
        ArrayList<String> errors = new ArrayList<String>();
        try {
            nodes = ConfTest.parseConf(in);
            if (nodes == null) {
                errors.add("bad conf file: top-level element not <configuration>");
            }
        }
        catch (XMLStreamException e) {
            errors.add("bad conf file: " + e.getMessage());
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        HashMap<String, ArrayList<Integer>> duplicatedProperties = new HashMap<String, ArrayList<Integer>>();
        for (NodeInfo nodeInfo : nodes) {
            StartElement element = nodeInfo.getStartElement();
            int line = element.getLocation().getLineNumber();
            if (!element.getName().equals(new QName("property"))) {
                errors.add(String.format("Line %d: element not <property>", line));
                continue;
            }
            List<XMLEvent> events = nodeInfo.getXMLEventsForQName(new QName("name"));
            if (events == null) {
                errors.add(String.format("Line %d: <property> has no <name>", line));
            } else {
                String v = null;
                for (XMLEvent event : events) {
                    if (event.isAttribute()) {
                        v = ((Attribute)event).getValue();
                    } else {
                        Characters c = nodeInfo.getElement(event.asStartElement());
                        if (c != null) {
                            v = c.getData();
                        }
                    }
                    if (v != null && !v.isEmpty()) continue;
                    errors.add(String.format("Line %d: <property> has an empty <name>", line));
                }
                if (v != null && !v.isEmpty()) {
                    ArrayList<Integer> lines = (ArrayList<Integer>)duplicatedProperties.get(v);
                    if (lines == null) {
                        lines = new ArrayList<Integer>();
                        duplicatedProperties.put(v, lines);
                    }
                    lines.add(nodeInfo.getStartElement().getLocation().getLineNumber());
                }
            }
            events = nodeInfo.getXMLEventsForQName(new QName("value"));
            if (events == null) {
                errors.add(String.format("Line %d: <property> has no <value>", line));
            }
            for (QName qName : nodeInfo.getDuplicatedQNames()) {
                if (qName.equals(new QName("source"))) continue;
                errors.add(String.format("Line %d: <property> has duplicated <%s>s", line, qName));
            }
        }
        for (Map.Entry entry : duplicatedProperties.entrySet()) {
            List lines = (List)entry.getValue();
            if (1 >= lines.size()) continue;
            errors.add(String.format("Line %s: duplicated <property>s for %s", StringUtils.join((CharSequence)", ", lines), entry.getKey()));
        }
        return errors;
    }

    private static File[] listFiles(File dir) {
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".xml");
            }
        });
    }

    public static void main(String[] args) throws IOException {
        GenericOptionsParser genericParser = new GenericOptionsParser(args);
        String[] remainingArgs = genericParser.getRemainingArgs();
        OptionBuilder.hasArg();
        Option conf = OptionBuilder.create("conffile");
        OptionBuilder.withLongOpt("help");
        Option help = OptionBuilder.create('h');
        Options opts = new Options().addOption(conf).addOption(help);
        GnuParser specificParser = new GnuParser();
        CommandLine cmd = null;
        try {
            cmd = specificParser.parse(opts, remainingArgs);
        }
        catch (MissingArgumentException e) {
            ConfTest.terminate(1, "No argument specified for -conffile option");
        }
        catch (ParseException e) {
            ConfTest.terminate(1, USAGE);
        }
        if (cmd == null) {
            ConfTest.terminate(1, "Failed to parse options");
        }
        if (cmd.hasOption('h')) {
            ConfTest.terminate(0, USAGE);
        }
        List<Object> files = new ArrayList();
        if (cmd.hasOption("conffile")) {
            String[] values = cmd.getOptionValues("conffile");
            for (String value : values) {
                File confFile = new File(value);
                if (confFile.isFile()) {
                    files.add(confFile);
                    continue;
                }
                if (confFile.isDirectory()) {
                    files.addAll(Arrays.asList(ConfTest.listFiles(confFile)));
                    continue;
                }
                ConfTest.terminate(1, confFile.getAbsolutePath() + " is neither a file nor directory");
            }
        } else {
            File confDir;
            String confDirName = System.getenv(HADOOP_CONF_DIR);
            if (confDirName == null) {
                ConfTest.terminate(1, "HADOOP_CONF_DIR is not defined");
            }
            if (!(confDir = new File(confDirName)).isDirectory()) {
                ConfTest.terminate(1, "HADOOP_CONF_DIR is not a directory");
            }
            files = Arrays.asList(ConfTest.listFiles(confDir));
        }
        if (files.isEmpty()) {
            ConfTest.terminate(1, "No input file to validate");
        }
        boolean ok = true;
        for (File file : files) {
            String path = file.getAbsolutePath();
            List<String> errors = ConfTest.checkConf(Files.newInputStream(file.toPath(), new OpenOption[0]));
            if (errors.isEmpty()) {
                System.out.println(path + ": valid");
                continue;
            }
            ok = false;
            System.err.println(path + ":");
            for (String error : errors) {
                System.err.println("\t" + error);
            }
        }
        if (ok) {
            System.out.println("OK");
        } else {
            ConfTest.terminate(1, "Invalid file exists");
        }
    }

    private static void terminate(int status, String msg) {
        System.err.println(msg);
        System.exit(status);
    }
}

