/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

class NodeInfo {
    private StartElement startElement;
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private Map<StartElement, Characters> elements = new HashMap<StartElement, Characters>();
    private Map<QName, List<XMLEvent>> qNameXMLEventsMap = new HashMap<QName, List<XMLEvent>>();

    public NodeInfo(StartElement startElement) {
        this.startElement = startElement;
    }

    private void addQNameXMLEvent(QName qName, XMLEvent event) {
        List<XMLEvent> events = this.qNameXMLEventsMap.get(qName);
        if (events == null) {
            events = new ArrayList<XMLEvent>();
            this.qNameXMLEventsMap.put(qName, events);
        }
        events.add(event);
    }

    public StartElement getStartElement() {
        return this.startElement;
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
        this.addQNameXMLEvent(attribute.getName(), attribute);
    }

    public Characters getElement(StartElement element) {
        return this.elements.get(element);
    }

    public void addElement(StartElement element) {
        this.setElement(element, null);
        this.addQNameXMLEvent(element.getName(), element);
    }

    public void setElement(StartElement element, Characters text) {
        this.elements.put(element, text);
    }

    public List<QName> getDuplicatedQNames() {
        ArrayList<QName> duplicates = new ArrayList<QName>();
        for (Map.Entry<QName, List<XMLEvent>> e : this.qNameXMLEventsMap.entrySet()) {
            if (1 >= e.getValue().size()) continue;
            duplicates.add(e.getKey());
        }
        return duplicates;
    }

    public List<XMLEvent> getXMLEventsForQName(QName qName) {
        return this.qNameXMLEventsMap.get(qName);
    }
}

