/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.util.hash;

import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.util.hash.Hash;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MurmurHash
extends Hash {
    private static MurmurHash _instance = new MurmurHash();

    public static Hash getInstance() {
        return _instance;
    }

    @Override
    public int hash(byte[] data, int length, int seed) {
        return this.hash(data, 0, length, seed);
    }

    public int hash(byte[] data, int offset, int length, int seed) {
        int m4 = 1540483477;
        int r = 24;
        int h2 = seed ^ length;
        int len_4 = length >> 2;
        for (int i = 0; i < len_4; ++i) {
            int i_4 = offset + (i << 2);
            int k = data[i_4 + 3];
            k <<= 8;
            k |= data[i_4 + 2] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 1] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 0] & 0xFF;
            k *= m4;
            k ^= k >>> r;
            h2 *= m4;
            h2 ^= (k *= m4);
        }
        int len_m = len_4 << 2;
        int left = length - len_m;
        if (left != 0) {
            length += offset;
            if (left >= 3) {
                h2 ^= data[length - 3] << 16;
            }
            if (left >= 2) {
                h2 ^= data[length - 2] << 8;
            }
            if (left >= 1) {
                h2 ^= data[length - 1];
            }
            h2 *= m4;
        }
        h2 ^= h2 >>> 13;
        h2 *= m4;
        h2 ^= h2 >>> 15;
        return h2;
    }
}

