/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.column.impl;

import java.io.IOException;
import net.snowflake.ingest.internal.apache.parquet.bytes.BytesInput;
import net.snowflake.ingest.internal.apache.parquet.column.ColumnDescriptor;
import net.snowflake.ingest.internal.apache.parquet.column.Encoding;
import net.snowflake.ingest.internal.apache.parquet.column.ParquetProperties;
import net.snowflake.ingest.internal.apache.parquet.column.impl.ColumnWriterBase;
import net.snowflake.ingest.internal.apache.parquet.column.page.PageWriter;
import net.snowflake.ingest.internal.apache.parquet.column.statistics.Statistics;
import net.snowflake.ingest.internal.apache.parquet.column.values.ValuesWriter;
import net.snowflake.ingest.internal.apache.parquet.column.values.bitpacking.DevNullValuesWriter;
import net.snowflake.ingest.internal.apache.parquet.column.values.bloomfilter.BloomFilterWriter;
import net.snowflake.ingest.internal.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import net.snowflake.ingest.internal.apache.parquet.column.values.rle.RunLengthBitPackingHybridValuesWriter;
import net.snowflake.ingest.internal.apache.parquet.io.ParquetEncodingException;

final class ColumnWriterV2
extends ColumnWriterBase {
    private static final ValuesWriter NULL_WRITER = new DevNullValuesWriter();

    ColumnWriterV2(ColumnDescriptor path, PageWriter pageWriter, ParquetProperties props) {
        super(path, pageWriter, props);
    }

    ColumnWriterV2(ColumnDescriptor path, PageWriter pageWriter, BloomFilterWriter bloomFilterWriter, ParquetProperties props) {
        super(path, pageWriter, bloomFilterWriter, props);
    }

    @Override
    ValuesWriter createRLWriter(ParquetProperties props, ColumnDescriptor path) {
        return path.getMaxRepetitionLevel() == 0 ? NULL_WRITER : new RLEWriterForV2(props.newRepetitionLevelEncoder(path));
    }

    @Override
    ValuesWriter createDLWriter(ParquetProperties props, ColumnDescriptor path) {
        return path.getMaxDefinitionLevel() == 0 ? NULL_WRITER : new RLEWriterForV2(props.newDefinitionLevelEncoder(path));
    }

    @Override
    void writePage(int rowCount, int valueCount, Statistics<?> statistics, ValuesWriter repetitionLevels, ValuesWriter definitionLevels, ValuesWriter values) throws IOException {
        BytesInput bytes = values.getBytes();
        Encoding encoding = values.getEncoding();
        this.pageWriter.writePageV2(rowCount, Math.toIntExact(statistics.getNumNulls()), valueCount, repetitionLevels.getBytes(), definitionLevels.getBytes(), encoding, bytes, statistics);
    }

    private static class RLEWriterForV2
    extends RunLengthBitPackingHybridValuesWriter {
        public RLEWriterForV2(RunLengthBitPackingHybridEncoder encoder) {
            super(encoder);
        }

        @Override
        public BytesInput getBytes() {
            try {
                return this.encoder.toBytes();
            }
            catch (IOException e) {
                throw new ParquetEncodingException(e);
            }
        }
    }
}

