/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.column.values.plain;

import java.io.IOException;
import net.snowflake.ingest.internal.apache.parquet.bytes.ByteBufferInputStream;
import net.snowflake.ingest.internal.apache.parquet.column.values.ValuesReader;
import net.snowflake.ingest.internal.apache.parquet.column.values.bitpacking.ByteBitPackingValuesReader;
import net.snowflake.ingest.internal.apache.parquet.column.values.bitpacking.Packer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanPlainValuesReader
extends ValuesReader {
    private static final Logger LOG = LoggerFactory.getLogger(BooleanPlainValuesReader.class);
    private ByteBitPackingValuesReader in = new ByteBitPackingValuesReader(1, Packer.LITTLE_ENDIAN);

    @Override
    public boolean readBoolean() {
        return this.in.readInteger() != 0;
    }

    @Override
    public void skip() {
        this.in.readInteger();
    }

    @Override
    public void initFromPage(int valueCount, ByteBufferInputStream stream) throws IOException {
        LOG.debug("init from page at offset {} for length {}", (Object)stream.position(), (Object)stream.available());
        this.in.initFromPage(valueCount, stream);
    }

    @Override
    @Deprecated
    public int getNextOffset() {
        return this.in.getNextOffset();
    }
}

