/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.hadoop;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.mapreduce.RecordWriter;
import net.snowflake.ingest.internal.apache.hadoop.mapreduce.TaskAttemptContext;
import net.snowflake.ingest.internal.apache.parquet.column.ParquetProperties;
import net.snowflake.ingest.internal.apache.parquet.hadoop.CodecFactory;
import net.snowflake.ingest.internal.apache.parquet.hadoop.InternalParquetRecordWriter;
import net.snowflake.ingest.internal.apache.parquet.hadoop.MemoryManager;
import net.snowflake.ingest.internal.apache.parquet.hadoop.ParquetFileWriter;
import net.snowflake.ingest.internal.apache.parquet.hadoop.api.WriteSupport;
import net.snowflake.ingest.internal.apache.parquet.hadoop.metadata.CompressionCodecName;
import net.snowflake.ingest.internal.apache.parquet.schema.MessageType;

public class ParquetRecordWriter<T>
extends RecordWriter<Void, T> {
    private final InternalParquetRecordWriter<T> internalWriter;
    private final MemoryManager memoryManager;
    private final CodecFactory codecFactory;

    @Deprecated
    public ParquetRecordWriter(ParquetFileWriter w, WriteSupport<T> writeSupport, MessageType schema, Map<String, String> extraMetaData, int blockSize, int pageSize, CodecFactory.BytesCompressor compressor, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion) {
        ParquetProperties props = ParquetProperties.builder().withPageSize(pageSize).withDictionaryPageSize(dictionaryPageSize).withDictionaryEncoding(enableDictionary).withWriterVersion(writerVersion).build();
        this.internalWriter = new InternalParquetRecordWriter<T>(w, writeSupport, schema, extraMetaData, blockSize, compressor, validating, props);
        this.memoryManager = null;
        this.codecFactory = null;
    }

    @Deprecated
    public ParquetRecordWriter(ParquetFileWriter w, WriteSupport<T> writeSupport, MessageType schema, Map<String, String> extraMetaData, long blockSize, int pageSize, CodecFactory.BytesCompressor compressor, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion, MemoryManager memoryManager) {
        ParquetProperties props = ParquetProperties.builder().withPageSize(pageSize).withDictionaryPageSize(dictionaryPageSize).withDictionaryEncoding(enableDictionary).withWriterVersion(writerVersion).build();
        this.internalWriter = new InternalParquetRecordWriter<T>(w, writeSupport, schema, extraMetaData, blockSize, compressor, validating, props);
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager cannot be null");
        memoryManager.addWriter(this.internalWriter, blockSize);
        this.codecFactory = null;
    }

    ParquetRecordWriter(ParquetFileWriter w, WriteSupport<T> writeSupport, MessageType schema, Map<String, String> extraMetaData, long blockSize, CompressionCodecName codec, boolean validating, ParquetProperties props, MemoryManager memoryManager, Configuration conf) {
        this.codecFactory = new CodecFactory(conf, props.getPageSizeThreshold());
        this.internalWriter = new InternalParquetRecordWriter<T>(w, writeSupport, schema, extraMetaData, blockSize, this.codecFactory.getCompressor(codec), validating, props);
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager cannot be null");
        memoryManager.addWriter(this.internalWriter, blockSize);
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        try {
            this.internalWriter.close();
        }
        finally {
            if (this.codecFactory != null) {
                this.codecFactory.release();
            }
            if (this.memoryManager != null) {
                this.memoryManager.removeWriter(this.internalWriter);
            }
        }
    }

    public void write(Void key, T value) throws IOException, InterruptedException {
        this.internalWriter.write(value);
    }
}

