/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.io.airlift.compress.lz4;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configurable;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionCodec;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionInputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionOutputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Compressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Decompressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.DoNotPool;
import net.snowflake.ingest.internal.io.airlift.compress.lz4.HadoopLz4InputStream;
import net.snowflake.ingest.internal.io.airlift.compress.lz4.HadoopLz4OutputStream;

public class Lz4Codec
implements Configurable,
CompressionCodec {
    private Configuration conf;

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return new HadoopLz4OutputStream(out, this.getBufferSize());
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        if (!(compressor instanceof HadoopLz4Compressor)) {
            throw new IllegalArgumentException("Compressor is not the LZ4 compressor");
        }
        return new HadoopLz4OutputStream(out, this.getBufferSize());
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        return HadoopLz4Compressor.class;
    }

    @Override
    public Compressor createCompressor() {
        return new HadoopLz4Compressor();
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return new HadoopLz4InputStream(in, this.getBufferSize());
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        if (!(decompressor instanceof HadoopLz4Decompressor)) {
            throw new IllegalArgumentException("Decompressor is not the LZ4 decompressor");
        }
        return new HadoopLz4InputStream(in, this.getBufferSize());
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return HadoopLz4Decompressor.class;
    }

    @Override
    public Decompressor createDecompressor() {
        return new HadoopLz4Decompressor();
    }

    @Override
    public String getDefaultExtension() {
        return ".lz4";
    }

    private int getBufferSize() {
        int maxUncompressedLength = this.conf != null ? this.conf.getInt("io.compression.codec.lz4.buffersize", 262144) : 262144;
        return maxUncompressedLength;
    }

    @DoNotPool
    private static class HadoopLz4Decompressor
    implements Decompressor {
        private HadoopLz4Decompressor() {
        }

        @Override
        public void setInput(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("LZ4 block decompressor is not supported");
        }

        @Override
        public boolean needsInput() {
            throw new UnsupportedOperationException("LZ4 block decompressor is not supported");
        }

        @Override
        public void setDictionary(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("LZ4 block decompressor is not supported");
        }

        @Override
        public boolean needsDictionary() {
            throw new UnsupportedOperationException("LZ4 block decompressor is not supported");
        }

        @Override
        public boolean finished() {
            throw new UnsupportedOperationException("LZ4 block decompressor is not supported");
        }

        @Override
        public int decompress(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException("LZ4 block decompressor is not supported");
        }

        @Override
        public int getRemaining() {
            throw new UnsupportedOperationException("LZ4 block decompressor is not supported");
        }

        @Override
        public void reset() {
        }

        @Override
        public void end() {
        }
    }

    @DoNotPool
    private static class HadoopLz4Compressor
    implements Compressor {
        private HadoopLz4Compressor() {
        }

        @Override
        public void setInput(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("LZ4 block compressor is not supported");
        }

        @Override
        public boolean needsInput() {
            throw new UnsupportedOperationException("LZ4 block compressor is not supported");
        }

        @Override
        public void setDictionary(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("LZ4 block compressor is not supported");
        }

        @Override
        public long getBytesRead() {
            throw new UnsupportedOperationException("LZ4 block compressor is not supported");
        }

        @Override
        public long getBytesWritten() {
            throw new UnsupportedOperationException("LZ4 block compressor is not supported");
        }

        @Override
        public void finish() {
            throw new UnsupportedOperationException("LZ4 block compressor is not supported");
        }

        @Override
        public boolean finished() {
            throw new UnsupportedOperationException("LZ4 block compressor is not supported");
        }

        @Override
        public int compress(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException("LZ4 block compressor is not supported");
        }

        @Override
        public void reset() {
        }

        @Override
        public void end() {
        }

        @Override
        public void reinit(Configuration conf) {
        }
    }
}

