/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.org.bouncycastle.cms;

import java.io.IOException;
import java.util.List;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.ASN1OctetString;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.ASN1Sequence;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cms.OriginatorPublicKey;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cms.RecipientEncryptedKey;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cms.RecipientKeyIdentifier;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.snowflake.ingest.internal.org.bouncycastle.cms.AuthAttributesProvider;
import net.snowflake.ingest.internal.org.bouncycastle.cms.CMSException;
import net.snowflake.ingest.internal.org.bouncycastle.cms.CMSSecureReadable;
import net.snowflake.ingest.internal.org.bouncycastle.cms.KeyAgreeRecipient;
import net.snowflake.ingest.internal.org.bouncycastle.cms.KeyAgreeRecipientId;
import net.snowflake.ingest.internal.org.bouncycastle.cms.OriginatorId;
import net.snowflake.ingest.internal.org.bouncycastle.cms.Recipient;
import net.snowflake.ingest.internal.org.bouncycastle.cms.RecipientId;
import net.snowflake.ingest.internal.org.bouncycastle.cms.RecipientInformation;
import net.snowflake.ingest.internal.org.bouncycastle.cms.RecipientOperator;
import net.snowflake.ingest.internal.org.bouncycastle.util.Arrays;

public class KeyAgreeRecipientInformation
extends RecipientInformation {
    private KeyAgreeRecipientInfo info;
    private ASN1OctetString encryptedKey;

    static void readRecipientInfo(List list, KeyAgreeRecipientInfo keyAgreeRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        ASN1Sequence aSN1Sequence = keyAgreeRecipientInfo.getRecipientEncryptedKeys();
        for (int i = 0; i < aSN1Sequence.size(); ++i) {
            KeyAgreeRecipientId keyAgreeRecipientId;
            RecipientEncryptedKey recipientEncryptedKey = RecipientEncryptedKey.getInstance(aSN1Sequence.getObjectAt(i));
            KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier = recipientEncryptedKey.getIdentifier();
            IssuerAndSerialNumber issuerAndSerialNumber = keyAgreeRecipientIdentifier.getIssuerAndSerialNumber();
            if (issuerAndSerialNumber != null) {
                keyAgreeRecipientId = new KeyAgreeRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
            } else {
                RecipientKeyIdentifier recipientKeyIdentifier = keyAgreeRecipientIdentifier.getRKeyID();
                keyAgreeRecipientId = new KeyAgreeRecipientId(recipientKeyIdentifier.getSubjectKeyIdentifier().getOctets());
            }
            list.add(new KeyAgreeRecipientInformation(keyAgreeRecipientInfo, keyAgreeRecipientId, recipientEncryptedKey.getEncryptedKey(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider));
        }
    }

    KeyAgreeRecipientInformation(KeyAgreeRecipientInfo keyAgreeRecipientInfo, RecipientId recipientId, ASN1OctetString aSN1OctetString, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(keyAgreeRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = keyAgreeRecipientInfo;
        this.rid = recipientId;
        this.encryptedKey = aSN1OctetString;
    }

    public OriginatorIdentifierOrKey getOriginator() {
        return this.info.getOriginator();
    }

    public byte[] getUserKeyingMaterial() {
        ASN1OctetString aSN1OctetString = this.info.getUserKeyingMaterial();
        if (aSN1OctetString != null) {
            return Arrays.clone(aSN1OctetString.getOctets());
        }
        return null;
    }

    private SubjectPublicKeyInfo getSenderPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, OriginatorIdentifierOrKey originatorIdentifierOrKey) throws CMSException, IOException {
        OriginatorId originatorId;
        OriginatorPublicKey originatorPublicKey = originatorIdentifierOrKey.getOriginatorKey();
        if (originatorPublicKey != null) {
            return this.getPublicKeyInfoFromOriginatorPublicKey(algorithmIdentifier, originatorPublicKey);
        }
        IssuerAndSerialNumber issuerAndSerialNumber = originatorIdentifierOrKey.getIssuerAndSerialNumber();
        if (issuerAndSerialNumber != null) {
            originatorId = new OriginatorId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        } else {
            SubjectKeyIdentifier subjectKeyIdentifier = originatorIdentifierOrKey.getSubjectKeyIdentifier();
            originatorId = new OriginatorId(subjectKeyIdentifier.getKeyIdentifier());
        }
        return this.getPublicKeyInfoFromOriginatorId(originatorId);
    }

    private SubjectPublicKeyInfo getPublicKeyInfoFromOriginatorPublicKey(AlgorithmIdentifier algorithmIdentifier, OriginatorPublicKey originatorPublicKey) {
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, originatorPublicKey.getPublicKey().getBytes());
        return subjectPublicKeyInfo;
    }

    private SubjectPublicKeyInfo getPublicKeyInfoFromOriginatorId(OriginatorId originatorId) throws CMSException {
        throw new CMSException("No support for 'originator' as IssuerAndSerialNumber or SubjectKeyIdentifier");
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        KeyAgreeRecipient keyAgreeRecipient = (KeyAgreeRecipient)recipient;
        AlgorithmIdentifier algorithmIdentifier = keyAgreeRecipient.getPrivateKeyAlgorithmIdentifier();
        return ((KeyAgreeRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.getSenderPublicKeyInfo(algorithmIdentifier, this.info.getOriginator()), this.info.getUserKeyingMaterial(), this.encryptedKey.getOctets());
    }
}

