/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.org.bouncycastle.openssl.jcajce;

import java.security.Provider;
import net.snowflake.ingest.internal.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.snowflake.ingest.internal.org.bouncycastle.jcajce.util.JcaJceHelper;
import net.snowflake.ingest.internal.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.snowflake.ingest.internal.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.snowflake.ingest.internal.org.bouncycastle.openssl.PEMDecryptor;
import net.snowflake.ingest.internal.org.bouncycastle.openssl.PEMDecryptorProvider;
import net.snowflake.ingest.internal.org.bouncycastle.openssl.PEMException;
import net.snowflake.ingest.internal.org.bouncycastle.openssl.PasswordException;
import net.snowflake.ingest.internal.org.bouncycastle.openssl.jcajce.PEMUtilities;

public class JcePEMDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcePEMDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePEMDecryptorProviderBuilder setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    public PEMDecryptorProvider build(final char[] cArray) {
        return new PEMDecryptorProvider(){

            @Override
            public PEMDecryptor get(final String string) {
                return new PEMDecryptor(){

                    @Override
                    public byte[] decrypt(byte[] byArray, byte[] byArray2) throws PEMException {
                        if (cArray == null) {
                            throw new PasswordException("Password is null, but a password is required");
                        }
                        return PEMUtilities.crypt(false, JcePEMDecryptorProviderBuilder.this.helper, byArray, cArray, string, byArray2);
                    }
                };
            }
        };
    }
}

