/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import net.snowflake.ingest.utils.Constants;

public class ParameterProvider {
    public static final String BUFFER_FLUSH_INTERVAL_IN_MILLIS = "STREAMING_INGEST_CLIENT_SDK_BUFFER_FLUSH_INTERVAL_IN_MILLIS".toLowerCase();
    public static final String BUFFER_FLUSH_CHECK_INTERVAL_IN_MILLIS = "STREAMING_INGEST_CLIENT_SDK_BUFFER_FLUSH_CHECK_INTERVAL_IN_MILLIS".toLowerCase();
    public static final String INSERT_THROTTLE_INTERVAL_IN_MILLIS = "STREAMING_INGEST_CLIENT_SDK_INSERT_THROTTLE_INTERVAL_IN_MILLIS".toLowerCase();
    public static final String INSERT_THROTTLE_THRESHOLD_IN_PERCENTAGE = "STREAMING_INGEST_CLIENT_SDK_INSERT_THROTTLE_THRESHOLD_IN_PERCENTAGE".toLowerCase();
    public static final String INSERT_THROTTLE_THRESHOLD_IN_BYTES = "STREAMING_INGEST_CLIENT_SDK_INSERT_THROTTLE_THRESHOLD_IN_BYTES".toLowerCase();
    public static final String ENABLE_SNOWPIPE_STREAMING_METRICS = "ENABLE_SNOWPIPE_STREAMING_JMX_METRICS".toLowerCase();
    public static final String BLOB_FORMAT_VERSION = "BLOB_FORMAT_VERSION".toLowerCase();
    public static final String IO_TIME_CPU_RATIO = "IO_TIME_CPU_RATIO".toLowerCase();
    public static final String BLOB_UPLOAD_MAX_RETRY_COUNT = "BLOB_UPLOAD_MAX_RETRY_COUNT".toLowerCase();
    public static final String MAX_MEMORY_LIMIT_IN_BYTES = "MAX_MEMORY_LIMIT_IN_BYTES".toLowerCase();
    public static final String ENABLE_PARQUET_INTERNAL_BUFFERING = "ENABLE_PARQUET_INTERNAL_BUFFERING".toLowerCase();
    public static final String MAX_CHANNEL_SIZE_IN_BYTES = "MAX_CHANNEL_SIZE_IN_BYTES".toLowerCase();
    public static final String MAX_CHUNK_SIZE_IN_BYTES = "MAX_CHUNK_SIZE_IN_BYTES".toLowerCase();
    public static final String MAX_ALLOWED_ROW_SIZE_IN_BYTES = "MAX_ALLOWED_ROW_SIZE_IN_BYTES".toLowerCase();
    public static final String MAX_CHUNKS_IN_BLOB_AND_REGISTRATION_REQUEST = "MAX_CHUNKS_IN_BLOB_AND_REGISTRATION_REQUEST".toLowerCase();
    public static final String MAX_CLIENT_LAG = "MAX_CLIENT_LAG".toLowerCase();
    public static final String BDEC_PARQUET_COMPRESSION_ALGORITHM = "BDEC_PARQUET_COMPRESSION_ALGORITHM".toLowerCase();
    public static final long BUFFER_FLUSH_CHECK_INTERVAL_IN_MILLIS_DEFAULT = 100L;
    public static final long INSERT_THROTTLE_INTERVAL_IN_MILLIS_DEFAULT = 1000L;
    public static final int INSERT_THROTTLE_THRESHOLD_IN_PERCENTAGE_DEFAULT = 10;
    public static final int INSERT_THROTTLE_THRESHOLD_IN_BYTES_DEFAULT = 0xC800000;
    public static final boolean SNOWPIPE_STREAMING_METRICS_DEFAULT = false;
    public static final Constants.BdecVersion BLOB_FORMAT_VERSION_DEFAULT = Constants.BdecVersion.THREE;
    public static final int IO_TIME_CPU_RATIO_DEFAULT = 2;
    public static final int BLOB_UPLOAD_MAX_RETRY_COUNT_DEFAULT = 24;
    public static final long MAX_MEMORY_LIMIT_IN_BYTES_DEFAULT = -1L;
    public static final long MAX_CHANNEL_SIZE_IN_BYTES_DEFAULT = 32000000L;
    public static final long MAX_CHUNK_SIZE_IN_BYTES_DEFAULT = 128000000L;
    public static final long MAX_CLIENT_LAG_DEFAULT = 1000L;
    static final long MAX_CLIENT_LAG_MS_MIN = TimeUnit.SECONDS.toMillis(1L);
    static final long MAX_CLIENT_LAG_MS_MAX = TimeUnit.MINUTES.toMillis(10L);
    public static final long MAX_ALLOWED_ROW_SIZE_IN_BYTES_DEFAULT = 0x4000000L;
    public static final int MAX_CHUNKS_IN_BLOB_AND_REGISTRATION_REQUEST_DEFAULT = 100;
    public static final Constants.BdecParquetCompression BDEC_PARQUET_COMPRESSION_ALGORITHM_DEFAULT = Constants.BdecParquetCompression.GZIP;
    public static final boolean ENABLE_PARQUET_INTERNAL_BUFFERING_DEFAULT = false;
    private final Map<String, Object> parameterMap = new HashMap<String, Object>();
    private Long cachedBufferFlushIntervalMs = -1L;

    public ParameterProvider(Map<String, Object> parameterOverrides, Properties props) {
        this.setParameterMap(parameterOverrides, props);
    }

    public ParameterProvider() {
        this(null, null);
    }

    private void updateValue(String key, Object defaultValue, Map<String, Object> parameterOverrides, Properties props) {
        if (parameterOverrides != null && props != null) {
            this.parameterMap.put(key, parameterOverrides.getOrDefault(key, props.getOrDefault((Object)key, defaultValue)));
        } else if (parameterOverrides != null) {
            this.parameterMap.put(key, parameterOverrides.getOrDefault(key, defaultValue));
        } else if (props != null) {
            this.parameterMap.put(key, props.getOrDefault((Object)key, defaultValue));
        }
    }

    private void setParameterMap(Map<String, Object> parameterOverrides, Properties props) {
        if (parameterOverrides != null && parameterOverrides.containsKey(BUFFER_FLUSH_INTERVAL_IN_MILLIS) || props != null && props.containsKey(BUFFER_FLUSH_INTERVAL_IN_MILLIS)) {
            throw new IllegalArgumentException(String.format("%s is deprecated, please use %s instead", BUFFER_FLUSH_INTERVAL_IN_MILLIS, MAX_CLIENT_LAG));
        }
        this.updateValue(BUFFER_FLUSH_CHECK_INTERVAL_IN_MILLIS, 100L, parameterOverrides, props);
        this.updateValue(INSERT_THROTTLE_INTERVAL_IN_MILLIS, 1000L, parameterOverrides, props);
        this.updateValue(INSERT_THROTTLE_THRESHOLD_IN_PERCENTAGE, 10, parameterOverrides, props);
        this.updateValue(INSERT_THROTTLE_THRESHOLD_IN_BYTES, 0xC800000, parameterOverrides, props);
        this.updateValue(ENABLE_SNOWPIPE_STREAMING_METRICS, false, parameterOverrides, props);
        this.updateValue(BLOB_FORMAT_VERSION, (Object)BLOB_FORMAT_VERSION_DEFAULT, parameterOverrides, props);
        this.getBlobFormatVersion();
        this.updateValue(IO_TIME_CPU_RATIO, 2, parameterOverrides, props);
        this.updateValue(BLOB_UPLOAD_MAX_RETRY_COUNT, 24, parameterOverrides, props);
        this.updateValue(MAX_MEMORY_LIMIT_IN_BYTES, -1L, parameterOverrides, props);
        this.updateValue(ENABLE_PARQUET_INTERNAL_BUFFERING, false, parameterOverrides, props);
        this.updateValue(MAX_CHANNEL_SIZE_IN_BYTES, 32000000L, parameterOverrides, props);
        this.updateValue(MAX_CHUNK_SIZE_IN_BYTES, 128000000L, parameterOverrides, props);
        this.updateValue(MAX_CLIENT_LAG, 1000L, parameterOverrides, props);
        this.updateValue(MAX_CHUNKS_IN_BLOB_AND_REGISTRATION_REQUEST, 100, parameterOverrides, props);
        this.updateValue(BDEC_PARQUET_COMPRESSION_ALGORITHM, (Object)BDEC_PARQUET_COMPRESSION_ALGORITHM_DEFAULT, parameterOverrides, props);
    }

    public long getCachedMaxClientLagInMs() {
        if (this.cachedBufferFlushIntervalMs != -1L) {
            return this.cachedBufferFlushIntervalMs;
        }
        this.cachedBufferFlushIntervalMs = this.getMaxClientLagInMs();
        return this.cachedBufferFlushIntervalMs;
    }

    private long getMaxClientLagInMs() {
        long computedLag;
        Object val = this.parameterMap.getOrDefault(MAX_CLIENT_LAG, 1000L);
        if (val instanceof String) {
            String maxLag = (String)val;
            String[] lagParts = maxLag.split(" ");
            if (lagParts.length > 2) {
                throw new IllegalArgumentException(String.format("Failed to parse MAX_CLIENT_LAG = '%s'", maxLag));
            }
            try {
                computedLag = Long.parseLong(lagParts[0]);
            }
            catch (Throwable t2) {
                throw new IllegalArgumentException(String.format("Failed to parse MAX_CLIENT_LAG = '%s'", lagParts[0]), t2);
            }
            if (lagParts.length == 2) {
                switch (lagParts[1].toLowerCase()) {
                    case "second": 
                    case "seconds": {
                        computedLag *= TimeUnit.SECONDS.toMillis(1L);
                        break;
                    }
                    case "minute": 
                    case "minutes": {
                        computedLag *= TimeUnit.SECONDS.toMillis(60L);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Invalid time unit supplied = '%s", lagParts[1]));
                    }
                }
            }
        } else {
            computedLag = (Long)val;
        }
        if (computedLag < MAX_CLIENT_LAG_MS_MIN || computedLag > MAX_CLIENT_LAG_MS_MAX) {
            throw new IllegalArgumentException(String.format("Lag falls outside of allowed time range. Minimum (milliseconds) = %s, Maximum (milliseconds) = %s", MAX_CLIENT_LAG_MS_MIN, MAX_CLIENT_LAG_MS_MAX));
        }
        return computedLag;
    }

    public long getBufferFlushCheckIntervalInMs() {
        Object val = this.parameterMap.getOrDefault(BUFFER_FLUSH_CHECK_INTERVAL_IN_MILLIS, 100L);
        if (val instanceof String) {
            return Long.parseLong(val.toString());
        }
        return (Long)val;
    }

    public long getInsertThrottleIntervalInMs() {
        Object val = this.parameterMap.getOrDefault(INSERT_THROTTLE_INTERVAL_IN_MILLIS, 1000L);
        if (val instanceof String) {
            return Long.parseLong(val.toString());
        }
        return (Long)val;
    }

    public int getInsertThrottleThresholdInPercentage() {
        Object val = this.parameterMap.getOrDefault(INSERT_THROTTLE_THRESHOLD_IN_PERCENTAGE, 10);
        if (val instanceof String) {
            return Integer.parseInt(val.toString());
        }
        return (Integer)val;
    }

    public int getInsertThrottleThresholdInBytes() {
        Object val = this.parameterMap.getOrDefault(INSERT_THROTTLE_THRESHOLD_IN_BYTES, 0xC800000);
        if (val instanceof String) {
            return Integer.parseInt(val.toString());
        }
        return (Integer)val;
    }

    public boolean hasEnabledSnowpipeStreamingMetrics() {
        Object val = this.parameterMap.getOrDefault(ENABLE_SNOWPIPE_STREAMING_METRICS, false);
        if (val instanceof String) {
            return Boolean.parseBoolean(val.toString());
        }
        return (Boolean)val;
    }

    public Constants.BdecVersion getBlobFormatVersion() {
        Object val = this.parameterMap.getOrDefault(BLOB_FORMAT_VERSION, (Object)BLOB_FORMAT_VERSION_DEFAULT);
        if (val instanceof Constants.BdecVersion) {
            return (Constants.BdecVersion)((Object)val);
        }
        if (val instanceof String) {
            try {
                val = Integer.parseInt((String)val);
            }
            catch (Throwable t2) {
                throw new IllegalArgumentException(String.format("Failed to parse BLOB_FORMAT_VERSION = '%s'", val), t2);
            }
        }
        return Constants.BdecVersion.fromInt((Integer)val);
    }

    public int getIOTimeCpuRatio() {
        Object val = this.parameterMap.getOrDefault(IO_TIME_CPU_RATIO, 2);
        if (val instanceof String) {
            return Integer.parseInt(val.toString());
        }
        return (Integer)val;
    }

    public int getBlobUploadMaxRetryCount() {
        Object val = this.parameterMap.getOrDefault(BLOB_UPLOAD_MAX_RETRY_COUNT, 24);
        if (val instanceof String) {
            return Integer.parseInt(val.toString());
        }
        return (Integer)val;
    }

    public long getMaxMemoryLimitInBytes() {
        Object val = this.parameterMap.getOrDefault(MAX_MEMORY_LIMIT_IN_BYTES, -1L);
        return val instanceof String ? Long.parseLong(val.toString()) : (Long)val;
    }

    public boolean getEnableParquetInternalBuffering() {
        Object val = this.parameterMap.getOrDefault(ENABLE_PARQUET_INTERNAL_BUFFERING, false);
        return val instanceof String ? Boolean.parseBoolean(val.toString()) : (Boolean)val;
    }

    public long getMaxChannelSizeInBytes() {
        Object val = this.parameterMap.getOrDefault(MAX_CHANNEL_SIZE_IN_BYTES, 32000000L);
        return val instanceof String ? Long.parseLong(val.toString()) : (Long)val;
    }

    public long getMaxChunkSizeInBytes() {
        Object val = this.parameterMap.getOrDefault(MAX_CHUNK_SIZE_IN_BYTES, 128000000L);
        return val instanceof String ? Long.parseLong(val.toString()) : (Long)val;
    }

    public long getMaxAllowedRowSizeInBytes() {
        Object val = this.parameterMap.getOrDefault(MAX_ALLOWED_ROW_SIZE_IN_BYTES, 0x4000000L);
        return val instanceof String ? Long.parseLong(val.toString()) : (Long)val;
    }

    public int getMaxChunksInBlobAndRegistrationRequest() {
        Object val = this.parameterMap.getOrDefault(MAX_CHUNKS_IN_BLOB_AND_REGISTRATION_REQUEST, 100);
        return val instanceof String ? Integer.parseInt(val.toString()) : (Integer)val;
    }

    public Constants.BdecParquetCompression getBdecParquetCompressionAlgorithm() {
        Object val = this.parameterMap.getOrDefault(BDEC_PARQUET_COMPRESSION_ALGORITHM, (Object)BDEC_PARQUET_COMPRESSION_ALGORITHM_DEFAULT);
        if (val instanceof Constants.BdecParquetCompression) {
            return (Constants.BdecParquetCompression)((Object)val);
        }
        return Constants.BdecParquetCompression.fromName((String)val);
    }

    public String toString() {
        return "ParameterProvider{parameterMap=" + this.parameterMap + '}';
    }
}

