/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.connection;

import java.io.IOException;
import net.snowflake.ingest.internal.fasterxml.jackson.core.JsonParseException;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.JsonMappingException;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.ObjectMapper;

public class IngestResponseException
extends Exception {
    private int errorCode;
    private IngestExceptionBody errorBody;

    IngestResponseException(int errorCode, IngestExceptionBody body) {
        super("HTTP Status: " + errorCode + " ErrorBody: " + body.toString());
        this.errorCode = errorCode;
        this.errorBody = body;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public IngestExceptionBody getErrorBody() {
        return this.errorBody;
    }

    @Override
    public String toString() {
        return "\nHTTP Status: " + this.errorCode + "\n" + this.errorBody.toString();
    }

    public static class IngestExceptionBody {
        private Object data;
        private String message;
        private String code;
        private boolean success;
        boolean validJson = true;
        String messageBlob;
        private String headers;
        private static ObjectMapper mapper = new ObjectMapper();

        public IngestExceptionBody() {
        }

        IngestExceptionBody(String blob) {
            this.messageBlob = blob;
            this.validJson = false;
        }

        static IngestExceptionBody parseBody(String blob) throws IOException {
            IngestExceptionBody body;
            try {
                body = mapper.readValue(blob, IngestExceptionBody.class);
            }
            catch (JsonParseException | JsonMappingException e) {
                body = new IngestExceptionBody(blob);
            }
            return body;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            if (this.validJson) {
                result.append("{\n").append("Message: ").append(this.message).append(",\n").append("Data: ").append(this.data).append("\n}\n");
            } else {
                result.append(this.messageBlob);
            }
            return result.toString();
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public String getHeaders() {
            return this.headers;
        }

        public void setHeaders(String headers) {
            this.headers = headers;
        }
    }
}

