/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.connection;

import java.security.KeyPair;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.snowflake.ingest.connection.SecurityManager;
import net.snowflake.ingest.connection.TelemetryService;
import net.snowflake.ingest.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWSAlgorithm;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWSHeader;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.RSASSASigner;
import net.snowflake.ingest.internal.com.nimbusds.jwt.JWTClaimsSet;
import net.snowflake.ingest.internal.com.nimbusds.jwt.SignedJWT;
import net.snowflake.ingest.utils.Cryptor;

public final class JWTManager
extends SecurityManager {
    private static final float LIFETIME_IN_MINUTES = 59.0f;
    private static final int RENEWAL_INTERVAL_IN_MINUTES = 54;
    private static final String TOKEN_TYPE = "KEYPAIR_JWT";
    private final transient KeyPair keyPair;
    private final AtomicReference<String> token;

    JWTManager(String accountName, String username, KeyPair keyPair, int timeTillRenewal, TimeUnit unit, TelemetryService telemetryService) {
        super(accountName, username, telemetryService);
        if (keyPair == null) {
            throw new IllegalArgumentException();
        }
        this.token = new AtomicReference();
        this.keyPair = keyPair;
        this.refreshToken();
        this.tokenRefresher.scheduleAtFixedRate(this::refreshToken, timeTillRenewal, timeTillRenewal, unit);
    }

    public JWTManager(String accountName, String username, KeyPair keyPair, TelemetryService telemetryService) {
        this(accountName, username, keyPair, 54, TimeUnit.MINUTES, telemetryService);
    }

    @Override
    public String getToken() {
        if (this.refreshFailed.get()) {
            LOGGER.error("getToken request failed due to token regeneration failure");
            throw new SecurityException();
        }
        return this.token.get();
    }

    @Override
    String getTokenType() {
        return TOKEN_TYPE;
    }

    @Override
    void refreshToken() {
        String newToken;
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        String subject = String.format("%s.%s", this.account, this.user);
        String publicKeyFPInJwt = this.calculatePublicKeyFp(this.keyPair);
        String issuer = String.format("%s.%s.%s", this.account, this.user, publicKeyFPInJwt);
        Date iat = new Date(System.currentTimeMillis());
        Date exp = new Date(iat.getTime() + 3540000L);
        JWTClaimsSet claimsSet = builder.issuer(issuer).subject(subject).issueTime(iat).expirationTime(exp).build();
        LOGGER.debug("Creating new JWT with subject {} and issuer {}...", (Object)subject, (Object)issuer);
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), claimsSet);
        RSASSASigner signer = new RSASSASigner(this.keyPair.getPrivate());
        try {
            signedJWT.sign(signer);
            newToken = signedJWT.serialize();
        }
        catch (JOSEException e) {
            this.refreshFailed.set(true);
            LOGGER.error("Failed to regenerate token! Exception is as follows : {}", (Object)e.getMessage());
            throw new SecurityException();
        }
        LOGGER.info("Successfully created new JWT");
        this.token.set(newToken);
        if (this.telemetryService != null) {
            this.telemetryService.refreshToken(newToken);
        }
    }

    private String calculatePublicKeyFp(KeyPair keyPair) {
        byte[] publicKeyRawBytes = keyPair.getPublic().getEncoded();
        this.publicKeyFingerPrint = String.format("SHA256:%s", Cryptor.sha256HashBase64(publicKeyRawBytes));
        return this.publicKeyFingerPrint;
    }

    @Override
    public void close() {
        this.tokenRefresher.shutdown();
    }
}

