/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.commons.configuration2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.snowflake.ingest.internal.apache.commons.configuration2.BaseHierarchicalConfiguration;
import net.snowflake.ingest.internal.apache.commons.configuration2.HierarchicalConfiguration;
import net.snowflake.ingest.internal.apache.commons.configuration2.ex.ConfigurationException;
import net.snowflake.ingest.internal.apache.commons.configuration2.io.ConfigurationLogger;
import net.snowflake.ingest.internal.apache.commons.configuration2.tree.ImmutableNode;

public class AbstractYAMLBasedConfiguration
extends BaseHierarchicalConfiguration {
    protected AbstractYAMLBasedConfiguration() {
        this.initLogger(new ConfigurationLogger(this.getClass()));
    }

    protected AbstractYAMLBasedConfiguration(HierarchicalConfiguration<ImmutableNode> c) {
        super(c);
        this.initLogger(new ConfigurationLogger(this.getClass()));
    }

    protected void load(Map<String, Object> map) {
        List<ImmutableNode> roots = AbstractYAMLBasedConfiguration.constructHierarchy("", map);
        this.getNodeModel().setRootNode(roots.get(0));
    }

    protected Map<String, Object> constructMap(ImmutableNode node) {
        HashMap<String, Object> map = new HashMap<String, Object>(node.getChildren().size());
        for (ImmutableNode cNode : node) {
            Map<String, Object> value = cNode.getChildren().isEmpty() ? cNode.getValue() : this.constructMap(cNode);
            AbstractYAMLBasedConfiguration.addEntry(map, cNode.getNodeName(), value);
        }
        return map;
    }

    private static void addEntry(Map<String, Object> map, String key, Object value) {
        Object oldValue = map.get(key);
        if (oldValue == null) {
            map.put(key, value);
        } else if (oldValue instanceof Collection) {
            Collection values = (Collection)oldValue;
            values.add(value);
        } else {
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(oldValue);
            values.add(value);
            map.put(key, values);
        }
    }

    private static List<ImmutableNode> constructHierarchy(String key, Object elem) {
        if (elem instanceof Map) {
            return AbstractYAMLBasedConfiguration.parseMap((Map)elem, key);
        }
        if (elem instanceof Collection) {
            return AbstractYAMLBasedConfiguration.parseCollection((Collection)elem, key);
        }
        return Collections.singletonList(new ImmutableNode.Builder().name(key).value(elem).create());
    }

    private static List<ImmutableNode> parseMap(Map<String, Object> map, String key) {
        ImmutableNode.Builder subtree = new ImmutableNode.Builder().name(key);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            List<ImmutableNode> children = AbstractYAMLBasedConfiguration.constructHierarchy(entry.getKey(), entry.getValue());
            for (ImmutableNode child : children) {
                subtree.addChild(child);
            }
        }
        return Collections.singletonList(subtree.create());
    }

    private static List<ImmutableNode> parseCollection(Collection<Object> col, String key) {
        ArrayList<ImmutableNode> nodes = new ArrayList<ImmutableNode>(col.size());
        for (Object elem : col) {
            nodes.addAll(AbstractYAMLBasedConfiguration.constructHierarchy(key, elem));
        }
        return nodes;
    }

    static void rethrowException(Exception e) throws ConfigurationException {
        if (e instanceof ClassCastException) {
            throw new ConfigurationException("Error parsing", e);
        }
        throw new ConfigurationException("Unable to load the configuration", e);
    }
}

