/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.local;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.fs.DelegateToFileSystem;
import net.snowflake.ingest.internal.apache.hadoop.fs.FsConstants;
import net.snowflake.ingest.internal.apache.hadoop.fs.FsServerDefaults;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.hadoop.fs.RawLocalFileSystem;
import net.snowflake.ingest.internal.apache.hadoop.fs.local.LocalConfigKeys;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RawLocalFs
extends DelegateToFileSystem {
    RawLocalFs(Configuration conf) throws IOException, URISyntaxException {
        this(FsConstants.LOCAL_FS_URI, conf);
    }

    RawLocalFs(URI theUri, Configuration conf) throws IOException, URISyntaxException {
        super(theUri, new RawLocalFileSystem(), conf, FsConstants.LOCAL_FS_URI.getScheme(), false);
    }

    @Override
    public int getUriDefaultPort() {
        return -1;
    }

    @Override
    public FsServerDefaults getServerDefaults(Path f) throws IOException {
        return LocalConfigKeys.getServerDefaults();
    }

    @Override
    @Deprecated
    public FsServerDefaults getServerDefaults() throws IOException {
        return LocalConfigKeys.getServerDefaults();
    }

    @Override
    public boolean isValidName(String src) {
        return true;
    }
}

