/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.viewfs;

import java.io.IOException;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.fs.FSDataInputStream;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileStatus;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileSystem;
import net.snowflake.ingest.internal.apache.hadoop.fs.LocatedFileStatus;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.hadoop.fs.RemoteIterator;
import net.snowflake.ingest.internal.apache.hadoop.fs.viewfs.FsGetter;
import net.snowflake.ingest.internal.apache.hadoop.fs.viewfs.MountTableConfigLoader;
import net.snowflake.ingest.internal.apache.hadoop.fs.viewfs.ViewFileSystemOverloadScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HCFSMountTableConfigLoader
implements MountTableConfigLoader {
    private static final String REGEX_DOT = "[.]";
    private static final Logger LOGGER = LoggerFactory.getLogger(HCFSMountTableConfigLoader.class);
    private Path mountTable = null;

    @Override
    public void load(String mountTableConfigPath, Configuration conf) throws IOException {
        this.mountTable = new Path(mountTableConfigPath);
        String scheme = this.mountTable.toUri().getScheme();
        ViewFileSystemOverloadScheme.ChildFsGetter fsGetter = new ViewFileSystemOverloadScheme.ChildFsGetter(scheme);
        try (FileSystem fs = ((FsGetter)fsGetter).getNewInstance(this.mountTable.toUri(), conf);){
            RemoteIterator<LocatedFileStatus> listFiles = fs.listFiles(this.mountTable, false);
            FileStatus lfs = null;
            int higherVersion = -1;
            while (listFiles.hasNext()) {
                LocatedFileStatus curLfs = listFiles.next();
                String cur = curLfs.getPath().getName();
                String[] nameParts = cur.split(REGEX_DOT);
                if (nameParts.length < 2) {
                    this.logInvalidFileNameFormat(cur);
                    continue;
                }
                int curVersion = higherVersion;
                try {
                    curVersion = Integer.parseInt(nameParts[nameParts.length - 2]);
                }
                catch (NumberFormatException nfe) {
                    this.logInvalidFileNameFormat(cur);
                    continue;
                }
                if (curVersion <= higherVersion) continue;
                higherVersion = curVersion;
                lfs = curLfs;
            }
            if (lfs == null) {
                LOGGER.warn("No valid mount-table file exist at: {}. At least one mount-table file should present with the name format: mount-table.<versionNumber>.xml", (Object)mountTableConfigPath);
                return;
            }
            Path latestVersionMountTable = lfs.getPath();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Loading the mount-table {} into configuration.", (Object)latestVersionMountTable);
            }
            try (FSDataInputStream open = fs.open(latestVersionMountTable);){
                Configuration newConf = new Configuration(false);
                newConf.addResource(open);
                conf.addResource(newConf);
            }
        }
    }

    private void logInvalidFileNameFormat(String cur) {
        LOGGER.warn("Invalid file name format for mount-table version file: {}. The valid file name format is mount-table-name.<versionNumber>.xml", (Object)cur);
    }
}

