/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Iterator;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configurable;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.io.ObjectWritable;
import net.snowflake.ingest.internal.apache.hadoop.io.Writable;
import net.snowflake.ingest.internal.apache.hadoop.io.WritableFactories;
import net.snowflake.ingest.internal.apache.hadoop.io.WritableFactory;
import net.snowflake.ingest.internal.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class EnumSetWritable<E extends Enum<E>>
extends AbstractCollection<E>
implements Writable,
Configurable {
    private EnumSet<E> value;
    private transient Class<E> elementType;
    private transient Configuration conf;

    EnumSetWritable() {
    }

    @Override
    public Iterator<E> iterator() {
        return this.value.iterator();
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean add(E e) {
        if (this.value == null) {
            this.value = EnumSet.of(e);
            this.set(this.value, null);
        }
        return this.value.add(e);
    }

    public EnumSetWritable(EnumSet<E> value, Class<E> elementType) {
        this.set(value, elementType);
    }

    public EnumSetWritable(EnumSet<E> value) {
        this(value, null);
    }

    public void set(EnumSet<E> value, Class<E> elementType) {
        if ((value == null || value.size() == 0) && this.elementType == null && elementType == null) {
            throw new IllegalArgumentException("The EnumSet argument is null, or is an empty set but with no elementType provided.");
        }
        this.value = value;
        if (value != null && value.size() > 0) {
            Iterator iterator = value.iterator();
            this.elementType = ((Enum)iterator.next()).getDeclaringClass();
        } else if (elementType != null) {
            this.elementType = elementType;
        }
    }

    public EnumSet<E> get() {
        return this.value;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int length = in.readInt();
        if (length == -1) {
            this.value = null;
        } else if (length == 0) {
            this.elementType = ObjectWritable.loadClass(this.conf, WritableUtils.readString(in));
            this.value = EnumSet.noneOf(this.elementType);
        } else {
            Enum first = (Enum)ObjectWritable.readObject(in, this.conf);
            this.value = EnumSet.of(first);
            for (int i = 1; i < length; ++i) {
                this.value.add((Enum)ObjectWritable.readObject(in, this.conf));
            }
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (this.value == null) {
            out.writeInt(-1);
            WritableUtils.writeString(out, this.elementType.getName());
        } else {
            Object[] array = this.value.toArray();
            int length = array.length;
            out.writeInt(length);
            if (length == 0) {
                if (this.elementType == null) {
                    throw new UnsupportedOperationException("Unable to serialize empty EnumSet with no element type provided.");
                }
                WritableUtils.writeString(out, this.elementType.getName());
            }
            for (int i = 0; i < length; ++i) {
                ObjectWritable.writeObject(out, array[i], array[i].getClass(), this.conf);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("null argument passed in equal().");
        }
        if (!(o instanceof EnumSetWritable)) {
            return false;
        }
        EnumSetWritable other = (EnumSetWritable)o;
        if (this == o || this.value == other.value) {
            return true;
        }
        if (this.value == null) {
            return false;
        }
        return this.value.equals(other.value);
    }

    public Class<E> getElementType() {
        return this.elementType;
    }

    @Override
    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "(null)";
        }
        return this.value.toString();
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    static {
        WritableFactories.setFactory(EnumSetWritable.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new EnumSetWritable();
            }
        });
    }
}

