/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.io.AbstractMapWritable;
import net.snowflake.ingest.internal.apache.hadoop.io.Writable;
import net.snowflake.ingest.internal.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class MapWritable
extends AbstractMapWritable
implements Map<Writable, Writable> {
    private Map<Writable, Writable> instance = new HashMap<Writable, Writable>();

    public MapWritable() {
    }

    public MapWritable(MapWritable other) {
        this();
        this.copy(other);
    }

    @Override
    public void clear() {
        this.instance.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.instance.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.instance.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Writable, Writable>> entrySet() {
        return this.instance.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MapWritable) {
            MapWritable map = (MapWritable)obj;
            if (this.size() != map.size()) {
                return false;
            }
            return this.entrySet().equals(map.entrySet());
        }
        return false;
    }

    @Override
    public Writable get(Object key) {
        return this.instance.get(key);
    }

    @Override
    public int hashCode() {
        return 1 + this.instance.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.instance.isEmpty();
    }

    @Override
    public Set<Writable> keySet() {
        return this.instance.keySet();
    }

    @Override
    public Writable put(Writable key, Writable value) {
        this.addToMap(key.getClass());
        this.addToMap(value.getClass());
        return this.instance.put(key, value);
    }

    @Override
    public void putAll(Map<? extends Writable, ? extends Writable> t2) {
        for (Map.Entry<? extends Writable, ? extends Writable> e : t2.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Writable remove(Object key) {
        return this.instance.remove(key);
    }

    @Override
    public int size() {
        return this.instance.size();
    }

    @Override
    public Collection<Writable> values() {
        return this.instance.values();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.instance.size());
        for (Map.Entry<Writable, Writable> e : this.instance.entrySet()) {
            out.writeByte(this.getId(e.getKey().getClass()));
            e.getKey().write(out);
            out.writeByte(this.getId(e.getValue().getClass()));
            e.getValue().write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.instance.clear();
        int entries = in.readInt();
        for (int i = 0; i < entries; ++i) {
            Writable key = (Writable)ReflectionUtils.newInstance(this.getClass(in.readByte()), this.getConf());
            key.readFields(in);
            Writable value = (Writable)ReflectionUtils.newInstance(this.getClass(in.readByte()), this.getConf());
            value.readFields(in);
            this.instance.put(key, value);
        }
    }

    public String toString() {
        return this.instance.toString();
    }
}

