/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CodecPool;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionInputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionOutputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Compressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Decompressor;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface CompressionCodec {
    public CompressionOutputStream createOutputStream(OutputStream var1) throws IOException;

    public CompressionOutputStream createOutputStream(OutputStream var1, Compressor var2) throws IOException;

    public Class<? extends Compressor> getCompressorType();

    public Compressor createCompressor();

    public CompressionInputStream createInputStream(InputStream var1) throws IOException;

    public CompressionInputStream createInputStream(InputStream var1, Decompressor var2) throws IOException;

    public Class<? extends Decompressor> getDecompressorType();

    public Decompressor createDecompressor();

    public String getDefaultExtension();

    public static class Util {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static CompressionOutputStream createOutputStreamWithCodecPool(CompressionCodec codec, Configuration conf, OutputStream out) throws IOException {
            Compressor compressor = CodecPool.getCompressor(codec, conf);
            CompressionOutputStream stream = null;
            try {
                stream = codec.createOutputStream(out, compressor);
            }
            finally {
                if (stream == null) {
                    CodecPool.returnCompressor(compressor);
                } else {
                    stream.setTrackedCompressor(compressor);
                }
            }
            return stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static CompressionInputStream createInputStreamWithCodecPool(CompressionCodec codec, Configuration conf, InputStream in) throws IOException {
            Decompressor decompressor = CodecPool.getDecompressor(codec);
            CompressionInputStream stream = null;
            try {
                stream = codec.createInputStream(in, decompressor);
            }
            finally {
                if (stream == null) {
                    CodecPool.returnDecompressor(decompressor);
                } else {
                    stream.setTrackedDecompressor(decompressor);
                }
            }
            return stream;
        }
    }
}

