/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.coder;

import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.CodecUtil;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.ECBlock;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.ECBlockGroup;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.coder.ErasureEncoder;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.coder.ErasureEncodingStep;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
public class RSErasureEncoder
extends ErasureEncoder {
    private RawErasureEncoder rawEncoder;

    public RSErasureEncoder(ErasureCoderOptions options) {
        super(options);
    }

    @Override
    protected ErasureCodingStep prepareEncodingStep(ECBlockGroup blockGroup) {
        RawErasureEncoder rawEncoder = this.checkCreateRSRawEncoder();
        ECBlock[] inputBlocks = this.getInputBlocks(blockGroup);
        return new ErasureEncodingStep(inputBlocks, this.getOutputBlocks(blockGroup), rawEncoder);
    }

    private RawErasureEncoder checkCreateRSRawEncoder() {
        if (this.rawEncoder == null) {
            this.rawEncoder = CodecUtil.createRawEncoder(this.getConf(), "rs", this.getOptions());
        }
        return this.rawEncoder;
    }

    @Override
    public void release() {
        if (this.rawEncoder != null) {
            this.rawEncoder.release();
        }
    }

    @Override
    public boolean preferDirectBuffer() {
        return false;
    }
}

