/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.ipc;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.io.Text;
import net.snowflake.ingest.internal.apache.hadoop.security.proto.SecurityProtos;
import net.snowflake.ingest.internal.apache.hadoop.security.token.Token;
import net.snowflake.ingest.internal.apache.hadoop.security.token.TokenIdentifier;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.protobuf.ByteString;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.protobuf.ServiceException;

@InterfaceAudience.Private
public class ProtobufHelper {
    private static final ConcurrentHashMap<Object, ByteString> FIXED_BYTESTRING_CACHE = new ConcurrentHashMap();

    private ProtobufHelper() {
    }

    public static IOException getRemoteException(ServiceException se) {
        Throwable e = se.getCause();
        if (e == null) {
            return new IOException(se);
        }
        return e instanceof IOException ? (IOException)e : new IOException(se);
    }

    @Deprecated
    public static IOException getRemoteException(net.snowflake.ingest.internal.com.google.protobuf.ServiceException se) {
        Throwable e = se.getCause();
        if (e == null) {
            return new IOException(se);
        }
        return e instanceof IOException ? (IOException)e : new IOException(se);
    }

    public static ByteString getFixedByteString(Text key) {
        ByteString value = FIXED_BYTESTRING_CACHE.get(key);
        if (value == null) {
            value = ByteString.copyFromUtf8(key.toString());
            FIXED_BYTESTRING_CACHE.put(new Text(key.copyBytes()), value);
        }
        return value;
    }

    public static ByteString getFixedByteString(String key) {
        ByteString value = FIXED_BYTESTRING_CACHE.get(key);
        if (value == null) {
            value = ByteString.copyFromUtf8(key);
            FIXED_BYTESTRING_CACHE.put(key, value);
        }
        return value;
    }

    public static ByteString getByteString(byte[] bytes) {
        return bytes.length == 0 ? ByteString.EMPTY : ByteString.copyFrom(bytes);
    }

    public static Token<? extends TokenIdentifier> tokenFromProto(SecurityProtos.TokenProto tokenProto) {
        Token token = new Token(tokenProto.getIdentifier().toByteArray(), tokenProto.getPassword().toByteArray(), new Text(tokenProto.getKind()), new Text(tokenProto.getService()));
        return token;
    }

    public static SecurityProtos.TokenProto protoFromToken(Token<?> tok) {
        SecurityProtos.TokenProto.Builder builder = SecurityProtos.TokenProto.newBuilder().setIdentifier(ProtobufHelper.getByteString(tok.getIdentifier())).setPassword(ProtobufHelper.getByteString(tok.getPassword())).setKindBytes(ProtobufHelper.getFixedByteString(tok.getKind())).setServiceBytes(ProtobufHelper.getFixedByteString(tok.getService()));
        return builder.build();
    }
}

