/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.metrics2.lib;

import java.util.concurrent.atomic.LongAdder;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.MetricsInfo;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.MetricsRecordBuilder;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.lib.MutableCounter;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableCounterLong
extends MutableCounter {
    private final LongAdder value = new LongAdder();

    public MutableCounterLong(MetricsInfo info, long initValue) {
        super(info);
        this.value.add(initValue);
    }

    @Override
    public void incr() {
        this.incr(1L);
    }

    public void incr(long delta) {
        this.value.add(delta);
        this.setChanged();
    }

    public long value() {
        return this.value.longValue();
    }

    @Override
    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            builder.addCounter(this.info(), this.value());
            this.clearChanged();
        }
    }
}

