/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.security.alias;

import java.io.IOException;
import java.net.URI;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.security.alias.CredentialProvider;
import net.snowflake.ingest.internal.apache.hadoop.security.alias.CredentialProviderFactory;
import net.snowflake.ingest.internal.apache.hadoop.security.alias.LocalKeyStoreProvider;

@InterfaceAudience.Private
public final class LocalBouncyCastleFipsKeyStoreProvider
extends LocalKeyStoreProvider {
    public static final String SCHEME_NAME = "localbcfks";
    public static final String KEYSTORE_TYPE = "bcfks";
    public static final String ALGORITHM = "HMACSHA512";

    private LocalBouncyCastleFipsKeyStoreProvider(URI uri, Configuration conf) throws IOException {
        super(uri, conf);
    }

    @Override
    protected String getSchemeName() {
        return SCHEME_NAME;
    }

    @Override
    protected String getKeyStoreType() {
        return KEYSTORE_TYPE;
    }

    @Override
    protected String getAlgorithm() {
        return ALGORITHM;
    }

    public static class Factory
    extends CredentialProviderFactory {
        @Override
        public CredentialProvider createProvider(URI providerName, Configuration conf) throws IOException {
            if (LocalBouncyCastleFipsKeyStoreProvider.SCHEME_NAME.equals(providerName.getScheme())) {
                return new LocalBouncyCastleFipsKeyStoreProvider(providerName, conf);
            }
            return null;
        }
    }
}

