/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.security.token;

import java.io.IOException;
import java.util.Arrays;
import net.snowflake.ingest.internal.apache.commons.codec.digest.DigestUtils;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.io.DataOutputBuffer;
import net.snowflake.ingest.internal.apache.hadoop.io.Text;
import net.snowflake.ingest.internal.apache.hadoop.io.Writable;
import net.snowflake.ingest.internal.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class TokenIdentifier
implements Writable {
    private String trackingId = null;

    public abstract Text getKind();

    public abstract UserGroupInformation getUser();

    public byte[] getBytes() {
        DataOutputBuffer buf = new DataOutputBuffer(4096);
        try {
            this.write(buf);
        }
        catch (IOException ie) {
            throw new RuntimeException("i/o error in getBytes", ie);
        }
        return Arrays.copyOf(buf.getData(), buf.getLength());
    }

    public String getTrackingId() {
        if (this.trackingId == null) {
            this.trackingId = DigestUtils.md5Hex(this.getBytes());
        }
        return this.trackingId;
    }
}

