/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.security.token.delegation;

import java.util.Collection;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.io.Text;
import net.snowflake.ingest.internal.apache.hadoop.security.token.Token;
import net.snowflake.ingest.internal.apache.hadoop.security.token.TokenIdentifier;
import net.snowflake.ingest.internal.apache.hadoop.security.token.TokenSelector;
import net.snowflake.ingest.internal.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class AbstractDelegationTokenSelector<TokenIdent extends AbstractDelegationTokenIdentifier>
implements TokenSelector<TokenIdent> {
    private Text kindName;

    protected AbstractDelegationTokenSelector(Text kindName) {
        this.kindName = kindName;
    }

    @Override
    public Token<TokenIdent> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        for (Token<? extends TokenIdentifier> token : tokens) {
            if (!this.kindName.equals(token.getKind()) || !service.equals(token.getService())) continue;
            return token;
        }
        return null;
    }
}

