/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.util;

import java.util.concurrent.atomic.AtomicReference;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.util.ExitCodeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce", "YARN"})
@InterfaceStability.Unstable
public final class ExitUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)ExitUtil.class.getName());
    private static volatile boolean systemExitDisabled = false;
    private static volatile boolean systemHaltDisabled = false;
    private static final AtomicReference<ExitException> FIRST_EXIT_EXCEPTION = new AtomicReference();
    private static final AtomicReference<HaltException> FIRST_HALT_EXCEPTION = new AtomicReference();
    public static final String EXIT_EXCEPTION_MESSAGE = "ExitException";
    public static final String HALT_EXCEPTION_MESSAGE = "HaltException";

    private ExitUtil() {
    }

    public static void disableSystemExit() {
        systemExitDisabled = true;
    }

    public static void disableSystemHalt() {
        systemHaltDisabled = true;
    }

    public static boolean terminateCalled() {
        return FIRST_EXIT_EXCEPTION.get() != null;
    }

    public static boolean haltCalled() {
        return FIRST_HALT_EXCEPTION.get() != null;
    }

    public static ExitException getFirstExitException() {
        return FIRST_EXIT_EXCEPTION.get();
    }

    public static HaltException getFirstHaltException() {
        return FIRST_HALT_EXCEPTION.get();
    }

    public static void resetFirstExitException() {
        FIRST_EXIT_EXCEPTION.set(null);
    }

    public static void resetFirstHaltException() {
        FIRST_HALT_EXCEPTION.set(null);
    }

    private static <T extends Throwable> T addSuppressed(T suppressor, T suppressed) {
        if (suppressor == null) {
            return suppressed;
        }
        if (suppressor != suppressed) {
            suppressor.addSuppressed(suppressed);
        }
        return suppressor;
    }

    public static void terminate(ExitException ee) throws ExitException {
        int status = ee.getExitCode();
        Error caught = null;
        if (status != 0) {
            try {
                String msg = ee.getMessage();
                LOG.debug("Exiting with status {}: {}", new Object[]{status, msg, ee});
                LOG.info("Exiting with status {}: {}", (Object)status, (Object)msg);
            }
            catch (Error e) {
                caught = e;
            }
            catch (Throwable t2) {
                ExitUtil.addSuppressed(ee, t2);
            }
        }
        if (systemExitDisabled) {
            try {
                LOG.error("Terminate called", (Throwable)ee);
            }
            catch (Error e) {
                caught = ExitUtil.addSuppressed(caught, e);
            }
            catch (Throwable t3) {
                ExitUtil.addSuppressed(ee, t3);
            }
            FIRST_EXIT_EXCEPTION.compareAndSet(null, ee);
            if (caught != null) {
                caught.addSuppressed(ee);
                throw caught;
            }
            throw ee;
        }
        System.exit(status);
    }

    public static void halt(HaltException he) throws HaltException {
        int status = he.getExitCode();
        Error caught = null;
        if (status != 0) {
            try {
                String msg = he.getMessage();
                LOG.info("Halt with status {}: {}", new Object[]{status, msg, he});
            }
            catch (Error e) {
                caught = e;
            }
            catch (Throwable t2) {
                ExitUtil.addSuppressed(he, t2);
            }
        }
        if (systemHaltDisabled) {
            try {
                LOG.error("Halt called", (Throwable)he);
            }
            catch (Error e) {
                caught = ExitUtil.addSuppressed(caught, e);
            }
            catch (Throwable t3) {
                ExitUtil.addSuppressed(he, t3);
            }
            FIRST_HALT_EXCEPTION.compareAndSet(null, he);
            if (caught != null) {
                caught.addSuppressed(he);
                throw caught;
            }
            throw he;
        }
        Runtime.getRuntime().halt(status);
    }

    public static void terminate(int status, Throwable t2) throws ExitException {
        if (t2 instanceof ExitException) {
            ExitUtil.terminate((ExitException)t2);
        } else {
            ExitUtil.terminate(new ExitException(status, t2));
        }
    }

    public static void halt(int status, Throwable t2) throws HaltException {
        if (t2 instanceof HaltException) {
            ExitUtil.halt((HaltException)t2);
        } else {
            ExitUtil.halt(new HaltException(status, t2));
        }
    }

    public static void terminate(int status) throws ExitException {
        ExitUtil.terminate(status, EXIT_EXCEPTION_MESSAGE);
    }

    public static void terminate(int status, String msg) throws ExitException {
        ExitUtil.terminate(new ExitException(status, msg));
    }

    public static void halt(int status) throws HaltException {
        ExitUtil.halt(status, HALT_EXCEPTION_MESSAGE);
    }

    public static void halt(int status, String message) throws HaltException {
        ExitUtil.halt(new HaltException(status, message));
    }

    public static void haltOnOutOfMemory(OutOfMemoryError oome) {
        try {
            System.err.println("Halting due to Out Of Memory Error...");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Runtime.getRuntime().halt(-1);
    }

    public static class HaltException
    extends RuntimeException
    implements ExitCodeProvider {
        private static final long serialVersionUID = 1L;
        public final int status;

        public HaltException(int status, Throwable cause) {
            super(cause);
            this.status = status;
        }

        public HaltException(int status, String msg) {
            super(msg);
            this.status = status;
        }

        public HaltException(int status, String message, Throwable cause) {
            super(message, cause);
            this.status = status;
        }

        @Override
        public int getExitCode() {
            return this.status;
        }

        @Override
        public String toString() {
            String message = this.getMessage();
            if (message == null) {
                message = super.toString();
            }
            return Integer.toString(this.status) + ": " + message;
        }
    }

    public static class ExitException
    extends RuntimeException
    implements ExitCodeProvider {
        private static final long serialVersionUID = 1L;
        public final int status;

        public ExitException(int status, String msg) {
            super(msg);
            this.status = status;
        }

        public ExitException(int status, String message, Throwable cause) {
            super(message, cause);
            this.status = status;
        }

        public ExitException(int status, Throwable cause) {
            super(cause);
            this.status = status;
        }

        @Override
        public int getExitCode() {
            return this.status;
        }

        @Override
        public String toString() {
            String message = this.getMessage();
            if (message == null) {
                message = super.toString();
            }
            return Integer.toString(this.status) + ": " + message;
        }
    }
}

