/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.util;

import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class UTF8ByteArrayUtils {
    public static int findByte(byte[] utf, int start, int end, byte b) {
        for (int i = start; i < end; ++i) {
            if (utf[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static int findBytes(byte[] utf, int start, int end, byte[] b) {
        int matchEnd = end - b.length;
        for (int i = start; i <= matchEnd; ++i) {
            boolean matched = true;
            for (int j = 0; j < b.length; ++j) {
                if (utf[i + j] == b[j]) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return i;
        }
        return -1;
    }

    public static int findNthByte(byte[] utf, int start, int length, byte b, int n) {
        int pos = -1;
        int nextStart = start;
        for (int i = 0; i < n; ++i) {
            pos = UTF8ByteArrayUtils.findByte(utf, nextStart, length, b);
            if (pos < 0) {
                return pos;
            }
            nextStart = pos + 1;
        }
        return pos;
    }

    public static int findNthByte(byte[] utf, byte b, int n) {
        return UTF8ByteArrayUtils.findNthByte(utf, 0, utf.length, b, n);
    }
}

