/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.util.concurrent;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import net.snowflake.ingest.internal.apache.hadoop.util.concurrent.ExecutorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopScheduledThreadPoolExecutor.class);

    public HadoopScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize);
    }

    public HadoopScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    public HadoopScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
    }

    public HadoopScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    @Override
    protected void beforeExecute(Thread t2, Runnable r) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeExecute in thread: " + Thread.currentThread().getName() + ", runnable type: " + r.getClass().getName());
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t2) {
        super.afterExecute(r, t2);
        ExecutorHelper.logThrowableFromAfterExecute(r, t2);
    }
}

