/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.column.values.bytestreamsplit;

import java.io.IOException;
import net.snowflake.ingest.internal.apache.parquet.bytes.ByteBufferInputStream;
import net.snowflake.ingest.internal.apache.parquet.column.values.ValuesReader;
import net.snowflake.ingest.internal.apache.parquet.io.ParquetDecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ByteStreamSplitValuesReader
extends ValuesReader {
    private static final Logger LOG = LoggerFactory.getLogger(ByteStreamSplitValuesReader.class);
    private final int elementSizeInBytes;
    private byte[] byteStreamData;
    private int indexInStream;
    private int valuesCount;

    protected ByteStreamSplitValuesReader(int elementSizeInBytes) {
        this.elementSizeInBytes = elementSizeInBytes;
        this.indexInStream = 0;
        this.valuesCount = 0;
    }

    protected void gatherElementDataFromStreams(byte[] gatheredData) throws ParquetDecodingException {
        if (gatheredData.length != this.elementSizeInBytes) {
            throw new ParquetDecodingException("gatherData buffer is not of the expected size.");
        }
        if (this.indexInStream >= this.valuesCount) {
            throw new ParquetDecodingException("Byte-stream data was already exhausted.");
        }
        for (int i = 0; i < this.elementSizeInBytes; ++i) {
            gatheredData[i] = this.byteStreamData[i * this.valuesCount + this.indexInStream];
        }
        ++this.indexInStream;
    }

    @Override
    public void initFromPage(int valuesCount, ByteBufferInputStream stream) throws ParquetDecodingException, IOException {
        LOG.debug("init from page at offset {} for length {}", (Object)stream.position(), (Object)stream.available());
        if (stream.available() % this.elementSizeInBytes != 0) {
            String errorMessage = String.format("Invalid ByteStreamSplit stream, total length: %d bytes, element size: %d bytes.", stream.available(), this.elementSizeInBytes);
            throw new ParquetDecodingException(errorMessage);
        }
        this.valuesCount = stream.available() / this.elementSizeInBytes;
        if (valuesCount < this.valuesCount) {
            String errorMessage = String.format("Invalid ByteStreamSplit stream, num values upper bound (w/ nulls): %d, num encoded values: %d", valuesCount, this.valuesCount);
            throw new ParquetDecodingException(errorMessage);
        }
        int totalSizeInBytes = stream.available();
        this.byteStreamData = new byte[totalSizeInBytes];
        int numRead = stream.read(this.byteStreamData, 0, totalSizeInBytes);
        if (numRead != totalSizeInBytes) {
            String errorMessage = String.format("Failed to read requested number of bytes. Expected: %d. Read %d.", totalSizeInBytes, numRead);
            throw new ParquetDecodingException(errorMessage);
        }
        this.indexInStream = 0;
    }

    @Override
    public void skip() {
        this.skip(1);
    }

    @Override
    public void skip(int n) {
        if (n < 0 || this.indexInStream + n > this.valuesCount) {
            String errorMessage = String.format("Cannot skip this many elements. Current index: %d. Skip %d. Total number of elements: %d", this.indexInStream, n, this.valuesCount);
            throw new ParquetDecodingException(errorMessage);
        }
        this.indexInStream += n;
    }
}

