/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.hadoop;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.snowflake.ingest.internal.apache.parquet.bytes.BytesInput;
import net.snowflake.ingest.internal.apache.parquet.column.ColumnDescriptor;
import net.snowflake.ingest.internal.apache.parquet.column.page.DictionaryPage;
import net.snowflake.ingest.internal.apache.parquet.column.page.DictionaryPageReadStore;
import net.snowflake.ingest.internal.apache.parquet.hadoop.ColumnChunkPageReadStore;
import net.snowflake.ingest.internal.apache.parquet.hadoop.ParquetFileReader;
import net.snowflake.ingest.internal.apache.parquet.hadoop.metadata.BlockMetaData;
import net.snowflake.ingest.internal.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import net.snowflake.ingest.internal.apache.parquet.io.ParquetDecodingException;

class DictionaryPageReader
implements DictionaryPageReadStore {
    private final ParquetFileReader reader;
    private final Map<String, ColumnChunkMetaData> columns;
    private final Map<String, Optional<DictionaryPage>> dictionaryPageCache;
    private ColumnChunkPageReadStore rowGroup = null;

    DictionaryPageReader(ParquetFileReader reader, BlockMetaData block) {
        this.reader = Objects.requireNonNull(reader);
        this.columns = new HashMap<String, ColumnChunkMetaData>();
        this.dictionaryPageCache = new ConcurrentHashMap<String, Optional<DictionaryPage>>();
        for (ColumnChunkMetaData column : block.getColumns()) {
            this.columns.put(column.getPath().toDotString(), column);
        }
    }

    void setRowGroup(ColumnChunkPageReadStore rowGroup) {
        this.rowGroup = rowGroup;
    }

    @Override
    public DictionaryPage readDictionaryPage(ColumnDescriptor descriptor) {
        if (this.rowGroup != null) {
            return this.rowGroup.readDictionaryPage(descriptor);
        }
        String dotPath = String.join((CharSequence)".", descriptor.getPath());
        ColumnChunkMetaData column = this.columns.get(dotPath);
        if (column == null) {
            throw new ParquetDecodingException("Failed to load dictionary, unknown column: " + dotPath);
        }
        return this.dictionaryPageCache.computeIfAbsent(dotPath, key -> {
            try {
                DictionaryPage dict = column.hasDictionaryPage() ? this.reader.readDictionary(column) : null;
                return dict != null ? Optional.of(DictionaryPageReader.reusableCopy(dict)) : Optional.empty();
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Failed to read dictionary", e);
            }
        }).orElse(null);
    }

    private static DictionaryPage reusableCopy(DictionaryPage dict) throws IOException {
        return new DictionaryPage(BytesInput.from(dict.getBytes().toByteArray()), dict.getDictionarySize(), dict.getEncoding());
    }
}

