/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.hadoop.codec;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Decompressor;
import net.snowflake.ingest.internal.apache.parquet.Preconditions;
import net.snowflake.ingest.internal.apache.parquet.hadoop.codec.CleanUtil;
import net.snowflake.ingest.internal.apache.parquet.hadoop.codec.SnappyUtil;

public abstract class NonBlockedDecompressor
implements Decompressor {
    private ByteBuffer outputBuffer = ByteBuffer.allocateDirect(0);
    private ByteBuffer inputBuffer = ByteBuffer.allocateDirect(0);
    private boolean finished;

    @Override
    public synchronized int decompress(byte[] buffer, int off, int len) throws IOException {
        SnappyUtil.validateBuffer(buffer, off, len);
        if (this.inputBuffer.position() == 0 && !this.outputBuffer.hasRemaining()) {
            return 0;
        }
        if (!this.outputBuffer.hasRemaining()) {
            this.inputBuffer.rewind();
            Preconditions.checkArgument(this.inputBuffer.position() == 0, "Invalid position of 0.");
            Preconditions.checkArgument(this.outputBuffer.position() == 0, "Invalid position of 0.");
            int decompressedSize = this.maxUncompressedLength(this.inputBuffer, len);
            if (decompressedSize > this.outputBuffer.capacity()) {
                ByteBuffer oldBuffer = this.outputBuffer;
                this.outputBuffer = ByteBuffer.allocateDirect(decompressedSize);
                CleanUtil.cleanDirectBuffer(oldBuffer);
            }
            this.outputBuffer.clear();
            int size = this.uncompress(this.inputBuffer, this.outputBuffer);
            this.outputBuffer.limit(size);
            this.inputBuffer.clear();
            this.inputBuffer.limit(0);
            this.finished = true;
        }
        int numBytes = Math.min(len, this.outputBuffer.remaining());
        this.outputBuffer.get(buffer, off, numBytes);
        return numBytes;
    }

    @Override
    public synchronized void setInput(byte[] buffer, int off, int len) {
        SnappyUtil.validateBuffer(buffer, off, len);
        if (this.inputBuffer.capacity() - this.inputBuffer.position() < len) {
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.inputBuffer.position() + len);
            this.inputBuffer.rewind();
            newBuffer.put(this.inputBuffer);
            ByteBuffer oldBuffer = this.inputBuffer;
            this.inputBuffer = newBuffer;
            CleanUtil.cleanDirectBuffer(oldBuffer);
        } else {
            this.inputBuffer.limit(this.inputBuffer.position() + len);
        }
        this.inputBuffer.put(buffer, off, len);
    }

    @Override
    public void end() {
        CleanUtil.cleanDirectBuffer(this.inputBuffer);
        CleanUtil.cleanDirectBuffer(this.outputBuffer);
    }

    @Override
    public synchronized boolean finished() {
        return this.finished && !this.outputBuffer.hasRemaining();
    }

    @Override
    public int getRemaining() {
        return 0;
    }

    @Override
    public synchronized boolean needsInput() {
        return !this.inputBuffer.hasRemaining() && !this.outputBuffer.hasRemaining();
    }

    @Override
    public synchronized void reset() {
        this.finished = false;
        this.inputBuffer.rewind();
        this.outputBuffer.rewind();
        this.inputBuffer.limit(0);
        this.outputBuffer.limit(0);
    }

    @Override
    public boolean needsDictionary() {
        return false;
    }

    @Override
    public void setDictionary(byte[] b, int off, int len) {
    }

    protected abstract int maxUncompressedLength(ByteBuffer var1, int var2) throws IOException;

    protected abstract int uncompress(ByteBuffer var1, ByteBuffer var2) throws IOException;
}

