/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.hadoop.codec;

import com.github.luben.zstd.BufferPool;
import com.github.luben.zstd.NoPool;
import com.github.luben.zstd.RecyclingBufferPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configurable;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionCodec;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionInputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionOutputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Compressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Decompressor;
import net.snowflake.ingest.internal.apache.parquet.hadoop.codec.ZstdCompressorStream;
import net.snowflake.ingest.internal.apache.parquet.hadoop.codec.ZstdDecompressorStream;

public class ZstandardCodec
implements Configurable,
CompressionCodec {
    public static final String PARQUET_COMPRESS_ZSTD_BUFFERPOOL_ENABLED = "parquet.compression.codec.zstd.bufferPool.enabled";
    public static final boolean DEFAULT_PARQUET_COMPRESS_ZSTD_BUFFERPOOL_ENABLED = true;
    public static final String PARQUET_COMPRESS_ZSTD_LEVEL = "parquet.compression.codec.zstd.level";
    public static final int DEFAULT_PARQUET_COMPRESS_ZSTD_LEVEL = 3;
    public static final String PARQUET_COMPRESS_ZSTD_WORKERS = "parquet.compression.codec.zstd.workers";
    public static final int DEFAULTPARQUET_COMPRESS_ZSTD_WORKERS = 0;
    private Configuration conf;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public Compressor createCompressor() {
        return null;
    }

    @Override
    public Decompressor createDecompressor() {
        return null;
    }

    @Override
    public CompressionInputStream createInputStream(InputStream stream, Decompressor decompressor) throws IOException {
        return this.createInputStream(stream);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream stream) throws IOException {
        BufferPool pool = this.conf.getBoolean(PARQUET_COMPRESS_ZSTD_BUFFERPOOL_ENABLED, true) ? RecyclingBufferPool.INSTANCE : NoPool.INSTANCE;
        return new ZstdDecompressorStream(stream, pool);
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream stream, Compressor compressor) throws IOException {
        return this.createOutputStream(stream);
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream stream) throws IOException {
        BufferPool pool = this.conf.getBoolean(PARQUET_COMPRESS_ZSTD_BUFFERPOOL_ENABLED, true) ? RecyclingBufferPool.INSTANCE : NoPool.INSTANCE;
        return new ZstdCompressorStream(stream, pool, this.conf.getInt(PARQUET_COMPRESS_ZSTD_LEVEL, 3), this.conf.getInt(PARQUET_COMPRESS_ZSTD_WORKERS, 0));
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        return null;
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return null;
    }

    @Override
    public String getDefaultExtension() {
        return ".zstd";
    }
}

