/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.hadoop.mapred;

import java.io.IOException;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileSystem;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.hadoop.mapred.FileOutputFormat;
import net.snowflake.ingest.internal.apache.hadoop.mapred.JobConf;
import net.snowflake.ingest.internal.apache.hadoop.mapred.RecordWriter;
import net.snowflake.ingest.internal.apache.hadoop.mapred.Reporter;
import net.snowflake.ingest.internal.apache.hadoop.util.Progressable;
import net.snowflake.ingest.internal.apache.parquet.hadoop.ParquetOutputFormat;
import net.snowflake.ingest.internal.apache.parquet.hadoop.ParquetRecordWriter;
import net.snowflake.ingest.internal.apache.parquet.hadoop.codec.CodecConfig;
import net.snowflake.ingest.internal.apache.parquet.hadoop.mapred.MapredParquetOutputCommitter;
import net.snowflake.ingest.internal.apache.parquet.hadoop.metadata.CompressionCodecName;

public class DeprecatedParquetOutputFormat<V>
extends FileOutputFormat<Void, V> {
    protected ParquetOutputFormat<V> realOutputFormat = new ParquetOutputFormat();

    public static void setWriteSupportClass(Configuration configuration, Class<?> writeSupportClass) {
        configuration.set("parquet.write.support.class", writeSupportClass.getName());
    }

    public static void setBlockSize(Configuration configuration, int blockSize) {
        configuration.setInt("parquet.block.size", blockSize);
    }

    public static void setPageSize(Configuration configuration, int pageSize) {
        configuration.setInt("parquet.page.size", pageSize);
    }

    public static void setCompression(Configuration configuration, CompressionCodecName compression) {
        configuration.set("parquet.compression", compression.name());
    }

    public static void setEnableDictionary(Configuration configuration, boolean enableDictionary) {
        configuration.setBoolean("parquet.enable.dictionary", enableDictionary);
    }

    public static void setAsOutputFormat(JobConf jobConf) {
        jobConf.setOutputFormat(DeprecatedParquetOutputFormat.class);
        jobConf.setOutputCommitter(MapredParquetOutputCommitter.class);
    }

    private CompressionCodecName getCodec(JobConf conf) {
        return CodecConfig.from(conf).getCodec();
    }

    private static Path getDefaultWorkFile(JobConf conf, String name, String extension) {
        String file = DeprecatedParquetOutputFormat.getUniqueName((JobConf)conf, (String)name) + extension;
        return new Path(DeprecatedParquetOutputFormat.getWorkOutputPath((JobConf)conf), file);
    }

    public RecordWriter<Void, V> getRecordWriter(FileSystem fs, JobConf conf, String name, Progressable progress) throws IOException {
        return new RecordWriterWrapper(this.realOutputFormat, fs, conf, name, progress);
    }

    private class RecordWriterWrapper
    implements RecordWriter<Void, V> {
        private ParquetRecordWriter<V> realWriter;

        public RecordWriterWrapper(ParquetOutputFormat<V> realOutputFormat, FileSystem fs, JobConf conf, String name, Progressable progress) throws IOException {
            CompressionCodecName codec = DeprecatedParquetOutputFormat.this.getCodec(conf);
            String extension = codec.getExtension() + ".parquet";
            Path file = DeprecatedParquetOutputFormat.getDefaultWorkFile(conf, name, extension);
            try {
                this.realWriter = (ParquetRecordWriter)realOutputFormat.getRecordWriter((Configuration)conf, file, codec);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new IOException(e);
            }
        }

        public void close(Reporter reporter) throws IOException {
            try {
                this.realWriter.close(null);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new IOException(e);
            }
        }

        public void write(Void key, V value) throws IOException {
            try {
                this.realWriter.write(key, value);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new IOException(e);
            }
        }
    }
}

