/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.com.google.common.collect;

import net.snowflake.ingest.internal.com.google.common.annotations.GwtCompatible;
import net.snowflake.ingest.internal.com.google.common.base.Preconditions;
import net.snowflake.ingest.internal.com.google.common.collect.ElementTypesAreNonnullByDefault;
import net.snowflake.ingest.internal.com.google.common.collect.ImmutableList;
import net.snowflake.ingest.internal.com.google.common.collect.ImmutableSet;
import net.snowflake.ingest.internal.com.google.common.collect.Iterators;
import net.snowflake.ingest.internal.com.google.common.collect.UnmodifiableIterator;
import net.snowflake.ingest.internal.javax.annotation.CheckForNull;
import net.snowflake.ingest.internal.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableSet<E>
extends ImmutableSet<E> {
    final transient E element;

    SingletonImmutableSet(E element) {
        this.element = Preconditions.checkNotNull(element);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(@CheckForNull Object target) {
        return this.element.equals(target);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public ImmutableList<E> asList() {
        return ImmutableList.of(this.element);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    int copyIntoArray(@Nullable Object[] dst, int offset) {
        dst[offset] = this.element;
        return offset + 1;
    }

    @Override
    public final int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public String toString() {
        return '[' + this.element.toString() + ']';
    }
}

