/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.io.airlift.compress.snappy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configurable;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionCodec;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionInputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionOutputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Compressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Decompressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.DoNotPool;
import net.snowflake.ingest.internal.io.airlift.compress.snappy.HadoopSnappyInputStream;
import net.snowflake.ingest.internal.io.airlift.compress.snappy.HadoopSnappyOutputStream;

public class SnappyCodec
implements Configurable,
CompressionCodec {
    private Configuration conf;

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream outputStream) throws IOException {
        return new HadoopSnappyOutputStream(outputStream, this.getBufferSize());
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream outputStream, Compressor compressor) throws IOException {
        if (!(compressor instanceof HadoopSnappyCompressor)) {
            throw new IllegalArgumentException("Compressor is not the Snappy decompressor");
        }
        return new HadoopSnappyOutputStream(outputStream, this.getBufferSize());
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        return HadoopSnappyCompressor.class;
    }

    @Override
    public Compressor createCompressor() {
        return new HadoopSnappyCompressor();
    }

    @Override
    public CompressionInputStream createInputStream(InputStream inputStream) throws IOException {
        return new HadoopSnappyInputStream(inputStream);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        if (!(decompressor instanceof HadoopSnappyDecompressor)) {
            throw new IllegalArgumentException("Decompressor is not the Snappy decompressor");
        }
        return new HadoopSnappyInputStream(in);
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return HadoopSnappyDecompressor.class;
    }

    @Override
    public Decompressor createDecompressor() {
        return new HadoopSnappyDecompressor();
    }

    @Override
    public String getDefaultExtension() {
        return ".snappy";
    }

    private int getBufferSize() {
        int maxUncompressedLength = this.conf != null ? this.conf.getInt("io.compression.codec.snappy.buffersize", 262144) : 262144;
        return maxUncompressedLength;
    }

    @DoNotPool
    private static class HadoopSnappyDecompressor
    implements Decompressor {
        private HadoopSnappyDecompressor() {
        }

        @Override
        public void setInput(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("Snappy block decompressor is not supported");
        }

        @Override
        public boolean needsInput() {
            throw new UnsupportedOperationException("Snappy block decompressor is not supported");
        }

        @Override
        public void setDictionary(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("Snappy block decompressor is not supported");
        }

        @Override
        public boolean needsDictionary() {
            throw new UnsupportedOperationException("Snappy block decompressor is not supported");
        }

        @Override
        public boolean finished() {
            throw new UnsupportedOperationException("Snappy block decompressor is not supported");
        }

        @Override
        public int decompress(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException("Snappy block decompressor is not supported");
        }

        @Override
        public int getRemaining() {
            throw new UnsupportedOperationException("Snappy block decompressor is not supported");
        }

        @Override
        public void reset() {
        }

        @Override
        public void end() {
        }
    }

    @DoNotPool
    private static class HadoopSnappyCompressor
    implements Compressor {
        private HadoopSnappyCompressor() {
        }

        @Override
        public void setInput(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("Snappy block compressor is not supported");
        }

        @Override
        public boolean needsInput() {
            throw new UnsupportedOperationException("Snappy block compressor is not supported");
        }

        @Override
        public void setDictionary(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("Snappy block compressor is not supported");
        }

        @Override
        public long getBytesRead() {
            throw new UnsupportedOperationException("Snappy block compressor is not supported");
        }

        @Override
        public long getBytesWritten() {
            throw new UnsupportedOperationException("Snappy block compressor is not supported");
        }

        @Override
        public void finish() {
            throw new UnsupportedOperationException("Snappy block compressor is not supported");
        }

        @Override
        public boolean finished() {
            throw new UnsupportedOperationException("Snappy block compressor is not supported");
        }

        @Override
        public int compress(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException("Snappy block compressor is not supported");
        }

        @Override
        public void reset() {
        }

        @Override
        public void end() {
        }

        @Override
        public void reinit(Configuration conf) {
        }
    }
}

