/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.org.bouncycastle.cms;

import net.snowflake.ingest.internal.org.bouncycastle.asn1.ASN1OctetString;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cms.RecipientIdentifier;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.ingest.internal.org.bouncycastle.cms.AuthAttributesProvider;
import net.snowflake.ingest.internal.org.bouncycastle.cms.CMSException;
import net.snowflake.ingest.internal.org.bouncycastle.cms.CMSSecureReadable;
import net.snowflake.ingest.internal.org.bouncycastle.cms.KeyTransRecipient;
import net.snowflake.ingest.internal.org.bouncycastle.cms.KeyTransRecipientId;
import net.snowflake.ingest.internal.org.bouncycastle.cms.Recipient;
import net.snowflake.ingest.internal.org.bouncycastle.cms.RecipientInformation;
import net.snowflake.ingest.internal.org.bouncycastle.cms.RecipientOperator;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(keyTransRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = keyTransRecipientInfo;
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

