/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.org.bouncycastle.jcajce.provider.asymmetric.elgamal;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.generators.ElGamalKeyPairGenerator;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.generators.ElGamalParametersGenerator;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.params.ElGamalParameters;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import net.snowflake.ingest.internal.org.bouncycastle.jcajce.provider.asymmetric.elgamal.BCElGamalPrivateKey;
import net.snowflake.ingest.internal.org.bouncycastle.jcajce.provider.asymmetric.elgamal.BCElGamalPublicKey;
import net.snowflake.ingest.internal.org.bouncycastle.jce.provider.BouncyCastleProvider;
import net.snowflake.ingest.internal.org.bouncycastle.jce.spec.ElGamalParameterSpec;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    ElGamalKeyGenerationParameters param;
    ElGamalKeyPairGenerator engine = new ElGamalKeyPairGenerator();
    int strength = 1024;
    int certainty = 20;
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("ElGamal");
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        this.strength = n;
        this.random = secureRandom;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof ElGamalParameterSpec) && !(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec or an ElGamalParameterSpec");
        }
        if (algorithmParameterSpec instanceof ElGamalParameterSpec) {
            ElGamalParameterSpec elGamalParameterSpec = (ElGamalParameterSpec)algorithmParameterSpec;
            this.param = new ElGamalKeyGenerationParameters(secureRandom, new ElGamalParameters(elGamalParameterSpec.getP(), elGamalParameterSpec.getG()));
        } else {
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            this.param = new ElGamalKeyGenerationParameters(secureRandom, new ElGamalParameters(dHParameterSpec.getP(), dHParameterSpec.getG(), dHParameterSpec.getL()));
        }
        this.engine.init(this.param);
        this.initialised = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        Object object;
        Object object2;
        if (!this.initialised) {
            object2 = BouncyCastleProvider.CONFIGURATION.getDHDefaultParameters(this.strength);
            if (object2 != null) {
                this.param = new ElGamalKeyGenerationParameters(this.random, new ElGamalParameters(((DHParameterSpec)object2).getP(), ((DHParameterSpec)object2).getG(), ((DHParameterSpec)object2).getL()));
            } else {
                object = new ElGamalParametersGenerator();
                ((ElGamalParametersGenerator)object).init(this.strength, this.certainty, this.random);
                this.param = new ElGamalKeyGenerationParameters(this.random, ((ElGamalParametersGenerator)object).generateParameters());
            }
            this.engine.init(this.param);
            this.initialised = true;
        }
        object2 = this.engine.generateKeyPair();
        object = (ElGamalPublicKeyParameters)((AsymmetricCipherKeyPair)object2).getPublic();
        ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)((AsymmetricCipherKeyPair)object2).getPrivate();
        return new KeyPair(new BCElGamalPublicKey((ElGamalPublicKeyParameters)object), new BCElGamalPrivateKey(elGamalPrivateKeyParameters));
    }
}

