/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.shaded.parquet.net.openhft.hashing;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.snowflake.ingest.internal.shaded.parquet.net.openhft.hashing.ByteBufferAccess;
import net.snowflake.ingest.internal.shaded.parquet.net.openhft.hashing.CharSequenceAccess;
import net.snowflake.ingest.internal.shaded.parquet.net.openhft.hashing.UnsafeAccess;

public abstract class Access<T> {
    public static <T> Access<T> unsafe() {
        return UnsafeAccess.INSTANCE;
    }

    public static Access<ByteBuffer> toByteBuffer() {
        return ByteBufferAccess.INSTANCE;
    }

    public static <T extends CharSequence> Access<T> toNativeCharSequence() {
        return CharSequenceAccess.nativeCharSequenceAccess();
    }

    public static <T extends CharSequence> Access<T> toCharSequence(ByteOrder backingOrder) {
        return CharSequenceAccess.charSequenceAccess(backingOrder);
    }

    protected Access() {
    }

    public long getLong(T input, long offset) {
        if (this.byteOrder(input) == ByteOrder.LITTLE_ENDIAN) {
            return this.getUnsignedInt(input, offset) | this.getUnsignedInt(input, offset + 4L) << 32;
        }
        return this.getUnsignedInt(input, offset + 4L) | this.getUnsignedInt(input, offset) << 32;
    }

    public long getUnsignedInt(T input, long offset) {
        return (long)this.getInt(input, offset) & 0xFFFFFFFFL;
    }

    public int getInt(T input, long offset) {
        if (this.byteOrder(input) == ByteOrder.LITTLE_ENDIAN) {
            return this.getUnsignedShort(input, offset) | this.getUnsignedShort(input, offset + 2L) << 16;
        }
        return this.getUnsignedShort(input, offset + 2L) | this.getUnsignedShort(input, offset) << 16;
    }

    public int getUnsignedShort(T input, long offset) {
        if (this.byteOrder(input) == ByteOrder.LITTLE_ENDIAN) {
            return this.getUnsignedByte(input, offset) | this.getUnsignedByte(input, offset + 1L) << 8;
        }
        return this.getUnsignedByte(input, offset + 1L) | this.getUnsignedByte(input, offset) << 8;
    }

    public int getShort(T input, long offset) {
        return (short)this.getUnsignedShort(input, offset);
    }

    public int getUnsignedByte(T input, long offset) {
        return this.getByte(input, offset) & 0xFF;
    }

    public abstract int getByte(T var1, long var2);

    public abstract ByteOrder byteOrder(T var1);
}

