/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming;

import net.snowflake.ingest.utils.Utils;

public class DropChannelRequest {
    private final String channelName;
    private final String dbName;
    private final String schemaName;
    private final String tableName;

    public static DropChannelRequestBuilder builder(String channelName) {
        return new DropChannelRequestBuilder(channelName);
    }

    public DropChannelRequest(DropChannelRequestBuilder builder) {
        Utils.assertStringNotNullOrEmpty("channel name", builder.channelName);
        Utils.assertStringNotNullOrEmpty("database name", builder.dbName);
        Utils.assertStringNotNullOrEmpty("schema name", builder.schemaName);
        Utils.assertStringNotNullOrEmpty("table name", builder.tableName);
        this.channelName = builder.channelName;
        this.dbName = builder.dbName;
        this.schemaName = builder.schemaName;
        this.tableName = builder.tableName;
    }

    public String getDBName() {
        return this.dbName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getFullyQualifiedTableName() {
        return String.format("%s.%s.%s", this.dbName, this.schemaName, this.tableName);
    }

    public static class DropChannelRequestBuilder {
        private final String channelName;
        private String dbName;
        private String schemaName;
        private String tableName;

        public DropChannelRequestBuilder(String channelName) {
            this.channelName = channelName;
        }

        public DropChannelRequestBuilder setDBName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public DropChannelRequestBuilder setSchemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public DropChannelRequestBuilder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public DropChannelRequest build() {
            return new DropChannelRequest(this);
        }
    }
}

